%define soname 15
%define build_type RelWithDebInfo
%define _cmake %cmake -DCMAKE_BUILD_TYPE=%build_type
%define optflags_lto %nil

Name: glslang
Version: 15.4.0
Release: alt1
Epoch: 1

Summary: OpenGL and OpenGL ES shader front end and validator
Group: Development/C++
License: BSD

Url: https://www.khronos.org/opengles/sdk/tools/Reference-Compiler/
Packager: L.A. Kostis <lakostis@altlinux.org>

Source: https://github.com/KhronosGroup/%name/archive/%version/%name-%version.tar

Patch0: glslang-alt-no-external-inc.patch

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: python3-devel libspirv-tools-devel >= 2025.3-alt0.1.rc1

%description
glslang is the official reference compiler front end for the OpenGL
ES and OpenGL shading languages. It implements a strict
interpretation of the specifications for these languages.

spirv-remap is a utility to improve compression of SPIR-V binary
files via entropy reduction, plus optional stripping of debug
information and load/store optimization. It transforms SPIR-V to
SPIR-V, remapping IDs. The resulting modules have an increased ID
range (IDs are not as tightly packed around zero), but will compress
better when multiple modules are compressed together, since
compressor's dictionary can find better cross module commonality.

%package -n lib%{name}%{soname}
Summary: %{name} shared libraries
Group: Development/C++

%description -n lib%{name}%{soname}
Contains shared libraries used by %{name}.

%package devel
Summary: %name development headers and libraries
Group: Development/C++
Requires: %name = %EVR

%description devel
%name development headers and libraries.

%prep
%setup
%autopatch -p2

%build
%_cmake \
  -DCMAKE_INSTALL_LIBDIR=%_lib \
  -DCMAKE_INSTALL_DATADIR=%_libdir/cmake \
  -DALLOW_EXTERNAL_SPIRV_TOOLS=ON \
  -DBUILD_EXTERNAL=OFF \
  -DBUILD_SHARED_LIBS:BOOL=TRUE
%cmake_build

%install
%cmake_install
pushd %buildroot%_includedir
rm -rf SPIRV
ln -s glslang/SPIRV SPIRV
popd

%files
%doc README-spirv-remap.txt
%_bindir/*

%files -n lib%{name}%{soname}
%_libdir/*.so.*

%files devel
%doc README.md
%_libdir/lib*.so
%_libdir/cmake/*
%_includedir/%name
%_includedir/SPIRV

%changelog
