%def_enable snapshot

%define _name gnome-bluetooth
%define ver_major 47
%define beta %nil
%define namespace GnomeBluetooth
%define api_ver 3.0
%define sover 13
%define _libexecdir %_prefix/libexec

%def_enable introspection
%def_enable gtk_doc
%def_enable sendto
%def_enable check

Name: %_name%api_ver
Version: %ver_major.1
Release: alt2%beta

Summary: The GNOME Bluetooth Subsystem
License: GPL-2.0-or-later and LGPL-2.1-or-later
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/GnomeBluetooth

Requires:  bluez >= 5.51
Requires: lib%name = %EVR rfkill

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz
%else
Source: %_name-%version.tar
%endif

%define gtk_ver 4.15.2
%define adwaita_ver 1.6
%define dbusmock_ver 0.30.0
%define upower_ver 0.99.14

BuildRequires(pre): rpm-macros-meson rpm-macros-alternatives
BuildRequires: meson yelp-tools
BuildRequires: libgio-devel libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libudev-devel libnotify-devel
BuildRequires: pkgconfig(upower-glib) >= %upower_ver libgsound-devel
%if_enabled introspection
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel
%endif
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:BuildRequires: bluez dbus python3-module-pygobject3 python3-module-dbus
BuildRequires: python3-module-dbusmock >= %dbusmock_ver typelib(Gtk) = 4.0}

%description
The GNOME Bluetooth Subsystem

%package -n lib%name
Summary: The GNOME Bluetooth Subsystem library
Group: System/Libraries

%description -n lib%name
This package provides GNOME Bluetooth Subsystem library.

%package -n lib%name-ui
Summary: The GNOME Bluetooth UI library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-ui
This package provides GNOME Bluetooth UI library.

%package -n lib%name-gir
Summary: GObject introspection data for the GNOME Bluetooth library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the GNOME Bluetooth library

%package -n lib%name-devel
Summary: The GNOME Bluetooth Subsystem development package
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package provides GNOME Bluetooth Subsystem development files

%package -n lib%name-ui-devel
Summary: The GNOME Bluetooth Subsystem development package
Group: Development/C
Requires: lib%name-ui = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-ui-devel
This package provides GNOME Bluetooth Subsystem development files

%package -n lib%name-devel-doc
Summary: The GNOME Bluetooth Subsystem development documentation
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package provides GNOME Bluetooth Subsystem development documentation

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GNOME Bluetooth library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Bluetooth library

%prep
%setup -n %_name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool sendto sendto}
%nil
%meson_build

%install
%meson_install

%if_enabled sendto
mv %buildroot%_bindir/bluetooth-sendto %buildroot%_bindir/%name-sendto
mv %buildroot%_desktopdir/bluetooth-sendto.desktop \
   %buildroot%_desktopdir/%name-bluetooth-sendto.desktop
sed -i 's|\(Exec=\)bluetooth\(-sendto\)|\1%name\2|' \
%buildroot%_desktopdir/%name-bluetooth-sendto.desktop

mkdir -p %buildroot%_altdir
cat > %buildroot%_altdir/%name <<EOF
%_bindir/bluetooth-sendto	%_bindir/%name-sendto	5
EOF
%endif

%find_lang --with-gnome --output=%_name.lang %_name-%api_ver

%check
dbus-run-session %__meson_test


%files -f %_name.lang
%{?_enable_sendto:%_altdir/%name
%_bindir/%name-sendto
%_desktopdir/%name-bluetooth-sendto.desktop
%_man1dir/bluetooth-sendto.1*}
%_datadir/%_name-%api_ver
%doc AUTHORS README* NEWS

%files -n lib%name
%_libdir/lib%_name-%api_ver.so.%{sover}*

%files -n lib%name-ui
%_libdir/lib%_name-ui-%api_ver.so.%{sover}*

%files -n lib%name-devel
%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc

%files -n lib%name-ui-devel
%_includedir/%_name-%api_ver
%_libdir/lib%_name-ui-%api_ver.so
%_pkgconfigdir/%_name-ui-%api_ver.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/%namespace-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%changelog
