# since 3.29.x depends on modules in %_libdir/%%name
%set_verify_elf_method unresolved=relaxed

%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 48
%define beta %nil
%define xdg_name org.gnome.Boxes
%def_enable check
%def_disable installed_tests

Name: gnome-boxes
Version: %ver_major.0
Release: alt1%beta

Summary: A GNOME 3 application to access virtual systems
Group: Emulators
License: LGPL-2.0-or-later
Url: https://apps.gnome.org/Boxes

Vcs: https://gitlab.gnome.org/GNOME/gnome-boxes.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.50.0
%define gtk_ver 3.22.20
%define libvirt_glib_ver 5.0.0
%define libxml2_ver 2.7.8
%define libusb_ver 1.0.9
%define spice_gtk_ver 0.41
%define gudev_ver 165
%define osinfo_ver 1.10.0
%define uuid_ver 1.41.3
%define soup3_ver 3.0.7
%define libarchive_ver 3.0.0
%define webkit_api_ver 4.1
%define webkit_ver 2.36
%define handy_ver 1.5.0

Requires: gnome-keyring dconf

# Need libvirtd and an hypervisor to do anything useful
Requires: libvirt libvirt-daemon libvirt-kvm
Requires: qemu-kvm

# Needed for unattended installations
Requires: fuseiso
Requires: mtools

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: gobject-introspection-devel >= 0.9.6
BuildRequires: libvala-devel >= 0.28.0.16
BuildRequires: glib2-devel >= %glib_ver libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libgtk+3-gir-devel
BuildRequires: libsecret-devel libsecret-gir-devel
BuildRequires: libvirt-gobject-devel >= %libvirt_glib_ver
BuildRequires: libvirt-gconfig-devel >= %libvirt_glib_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libusb-devel >= %libusb_ver
BuildRequires: pkgconfig(spice-client-gtk-3.0) >= %spice_gtk_ver
BuildRequires: libgudev-devel >= %gudev_ver
BuildRequires: libosinfo-devel >= %osinfo_ver
BuildRequires: libuuid-devel >= %uuid_ver
BuildRequires: libsoup3.0-devel >= %soup3_ver
BuildRequires: libarchive-devel >= %libarchive_ver
BuildRequires: pkgconfig(webkit2gtk-%webkit_api_ver) >= %webkit_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: pkgconfig(libportal-gtk3)
%{?_enable_check:BuildRequires: yelp-tools /usr/bin/appstreamcli /usr/bin/desktop-file-validate}

%description
gnome-boxes lets you easily create, setup, access, and use:
  * remote machines
  * remote virtual machines
  * local virtual machines
  * When technology permits, set up access for applications on
    local virtual machines

How to setup Libvirt see https://www.altlinux.org/Libvirt_(Qemu+KVM+Virt-manager).

%package tests
Summary: Tests for the Boxes
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the Boxes.


%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool installed_tests installed_tests}
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%check
%__meson_test

%files -f %name.lang
%doc README* NEWS
%_bindir/%name
%_libdir/%name/
%_datadir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/org.gnome.boxes.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*
%_libexecdir/gnome-boxes-search-provider
%_datadir/dbus-1/services/*.service
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_datadir/metainfo/*.xml

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif

%exclude %_includedir/%name/

%changelog
