# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: gnome-shell-extension-arcmenu
Version: 67.0
Release: alt1
Summary: Application menu for GNOME Shell
License: GPL-2.0-or-later
Group:  Graphical desktop/GNOME
Url: https://gitlab.com/arcmenu/ArcMenu
Vcs: https://gitlab.com/arcmenu/ArcMenu
Source: %name-%version.tar
Source1: 00_arcmenu-disable-notification.gschema.override
Patch: %name-%version-%release.patch

BuildArch: noarch

Requires: gnome-shell >= 47.0
# https://bugzilla.altlinux.org/53075
Requires: libgnome-menus-gir
BuildRequires: %_bindir/glib-compile-schemas

%description
ArcMenu is an application menu for GNOME Shell, designed to provide a more
familiar user experience and workflow. This extension has many features,
including various menu layout styles, GNOME search, quick access to system
shortcuts, and much more!

%prep
%setup
%autopatch -p1

%build
%make_build

%install
%makeinstall_std
%find_lang arcmenu

install -Dm644 %SOURCE1 \
	%buildroot%_datadir/glib-2.0/schemas/00_arcmenu-disable-notification.gschema.override

%files -f arcmenu.lang
%_datadir/gnome-shell/extensions/arcmenu@arcmenu.com
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.arcmenu.gschema.xml
%_datadir/glib-2.0/schemas/00_arcmenu-disable-notification.gschema.override
%doc README.md

%changelog
