%def_disable LibreSSL
%def_enable openssl
%def_disable gnutls

Name: gnupg-pkcs11-scd
Version: 0.9.2
Release: alt8

Summary: A GnuPG PKCS#11 token daemon
Group: System/Configuration/Hardware
License: BSD
Url: https://github.com/alonbl/gnupg-pkcs11-scd

Source: %name-%version.tar
Patch0: %name-%version-gost.patch

%if_enabled LibreSSL
BuildRequires: LibreSSL-devel
%else %if_enabled openssl
BuildRequires: libssl-devel
%endif
%if_enabled gnutls
BuildRequires: libgnutls-devel
%endif
BuildRequires: libassuan-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgpg-error-devel
BuildRequires: libpkcs11-helper-devel

Requires: libpkcs11-helper(vko) >= 2.0.0

%description
gnupg-pkcs11 is a project to implement a BSD-licensed smart-card daemon to
enable the use of PKCS#11 tokens with GnuPG.

PKCS#11 is the de-facto standard for accessing cryptographic tokens, and thus
we strongly disagree with WK\'s attitude towards it.

%prep
%setup
%patch0 -p1

%build
%autoreconf
%configure --enable-proxy --localstatedir=%_var
%make_build

%install
%makeinstall_std

%check
#%make check

%files
%_bindir/*
%exclude %_docdir/%name/COPYING
%_docdir/%name/README
%_docdir/%name/*.conf.example
%_man1dir/*.1.*

%changelog
