Name: gnupg2
Version: 2.4.3
Release: alt1

Group: Text tools
Summary: The GNU Privacy Guard suite
License: GPL-3.0-or-later
Url: https://www.gnupg.org/

Source0: %name-%version.tar
Source1: gnupg-agent.sh

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define _localstatedir /var

%set_verify_elf_method strict

Provides: newpg = %version-%release
Obsoletes: newpg < %version-%release

Provides: dirmngr = %version-%release
Obsoletes: dirmngr < %version-%release

Provides: gnupg-agent = %version-%release
Provides: %name-gpg = %version-%release

Provides: %name-agent = %version-%release
Obsoletes: %name-agent < %version-%release

Provides: %name-common = %version-%release
Obsoletes: %name-common < %version-%release

# due to passing OPTION allow-external-password-cache
Conflicts: pinentry < 0.9.2
Conflicts: pinentry-common < 0.9.2
Conflicts: gnupg-pkcs11-scd <= 0.9.2-alt5

Patch0001: 0001-FEDORA-compatibility-with-system-FIPS-mode.patch
Patch0002: 0002-FEDORA-disable-DIGEST_ALGO_RMD160-in-fips-mode.patch
Patch0003: 0003-FEDORA-allow-8192-bit-RSA-keys-in-keygen-UI-with-lar.patch
Patch0004: 0004-FEDORA-non-upstreamable-patch-adding-file-is-digest-.patch
Patch0005: 0005-gpg-allow-import-of-previously-known-keys-even-witho.patch
Patch0006: 0006-tests-add-test-cases-for-import-without-uid.patch
Patch0007: 0007-gpg-accept-subkeys-with-a-good-revocation-but-no-sel.patch
Patch0008: 0008-g10-Fix-memory-leaks.patch
Patch0009: 0009-dirmgr-Avoid-memory-leaks.patch
Patch0010: 0010-scd-Avoid-memory-leaks-and-uninitialized-memory.patch
Patch0011: 0011-tools-Avoid-memory-leaks.patch
Patch0012: 0012-scd-Use-the-same-allocator-to-free-memory.patch
Patch0013: 0013-Revert-the-introduction-of-the-RFC4880bis-draft-into.patch
Patch0014: 0014-gpg-Report-BEGIN_-status-before-examining-the-input.patch
Patch0015: 0015-ALT-replace-xloadimage-by-xli.patch
Patch0016: 0016-ALT-replace-gnupg-by-gnupg2-in-texinfo.patch
Patch0017: 0017-SUSE-set-umask-before-open-outfile.patch
Patch0018: 0018-gpg-Prefer-SHA-512-and-SHA-384-in-personal-digest-pr.patch
Patch0019: 0019-ALT-disable-warning-about-development-mode.patch
Patch0020: 0020-ALT-Disable-own-copy-of-xtryreallocarray.patch

BuildRequires: libldap-devel
BuildRequires: libreadline-devel
BuildRequires: makeinfo
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(gnutls)
BuildRequires: pkgconfig(ksba)
BuildRequires: pkgconfig(libassuan)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libgcrypt)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(npth)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(zlib)

# for tests
BuildRequires: /proc

%description
GnuPG is GNU's tool for secure communication and data storage.  It can
be used to encrypt data and to create digital signatures.  It includes
an advanced key management facility and is compliant with the proposed
OpenPGP Internet standard as described in RFC2440 and the S/MIME
standard as described by several RFCs.

GnuPG 2.0 is a newer version of GnuPG with additional support for
S/MIME.  It has a different design philosophy that splits
functionality up into several modules.

%prep
%setup
%autopatch -p1

%build
%autoreconf

%configure \
	--disable-doc \
	--disable-rpath \
	--enable-g13 \
	--enable-gpg-is-gpg2 \
	--enable-large-secmem \
	--enable-maintainer-mode \
	--enable-symcryptrun \
	--libexecdir=%_libexecdir/gnupg \
	--with-capabilities \
	--with-default-trust-store-file=%_datadir/ca-certificates/ca-bundle.crt \
	--with-mailprog=%_sbindir/sendmail \
	--with-pinentry-pgm=%_bindir/pinentry \
	#

%make_build
%make_build -C doc gnupg.7 gnupg.info help.txt

%install
%makeinstall_std

rm -r -- \
	%buildroot%_docdir/gnupg \
	%buildroot%_sbindir/addgnupghome \
	%buildroot%_sbindir/applygnupgdefaults \
	#

mv %buildroot%_bindir/gpg{,2}split

install -D -m 0644 doc/examples/gpgconf.conf %buildroot%_sysconfdir/gnupg/gpgconf.conf
install -D -m 0644 doc/gnupg.info %buildroot%_infodir/gnupg.info

mkdir -p -- %buildroot%_sysconfdir/profile.d
install -pm 0755 %SOURCE1 %buildroot%_sysconfdir/profile.d/

mkdir -p -- %buildroot%_datadir/gnupg
install -pm 0644 doc/help*.txt %buildroot%_datadir/gnupg/

mkdir -p -- %buildroot%_man1dir
install -pm 0644 doc/*.1 %buildroot%_man1dir/

mkdir -p -- %buildroot%_man7dir
install -pm 0644 doc/*.7 %buildroot%_man7dir/

mkdir -p -- %buildroot%_man8dir
install -pm 0644 doc/*.8 %buildroot%_man8dir/

%find_lang %name

%check
ln -s gpg bin/gpg2 # hack
%make_build -k check

%pre
/usr/sbin/groupadd -r -f _gnupg

%files -f %name.lang
%dir %_sysconfdir/gnupg
%config(noreplace) %_sysconfdir/gnupg/gpgconf.conf
%config %_sysconfdir/profile.d/*.sh
%_bindir/dirmngr
%_bindir/dirmngr-client
%_bindir/g13
%_bindir/gpg-card
%_bindir/gpg-connect-agent
%_bindir/gpg-wks-client
%_bindir/gpg-wks-server
%_bindir/gpg2split
%_bindir/gpgconf
%_bindir/gpgparsemail
%_bindir/gpgscm
%_bindir/gpgsm
%_bindir/gpgtar
%_bindir/gpgv2
%_bindir/kbxutil
%_bindir/watchgnupg
%_sbindir/g13-syshelp
%attr(2711,root,_gnupg) %_bindir/gpg-agent
%attr(2711,root,_gnupg) %_bindir/gpg2
%dir %_libexecdir/gnupg
%_libexecdir/gnupg/dirmngr_ldap
%_libexecdir/gnupg/gpg-auth
%_libexecdir/gnupg/gpg-check-pattern
%_libexecdir/gnupg/gpg-pair-tool
%_libexecdir/gnupg/gpg-preset-passphrase
%_libexecdir/gnupg/gpg-protect-tool
%_libexecdir/gnupg/gpg-wks-client
%_libexecdir/gnupg/keyboxd
%_libexecdir/gnupg/scdaemon
%dir %_datadir/gnupg
%_datadir/gnupg/distsigkey.gpg
%_datadir/gnupg/sks-keyservers.netCA.pem
%_datadir/gnupg/help*.txt
%_infodir/*.info*
%_man1dir/*
%_man7dir/*
%_man8dir/*
%doc AUTHORS NEWS README doc/OpenPGP doc/KEYSERVER
%doc doc/examples/gpgconf.conf doc/examples/trustlist.txt
%doc tools/addgnupghome tools/applygnupgdefaults

%changelog
