%global import_path golang.org/x/tools
%global commit 8c34cc9cafff8f13c3f3ed95a11de309752c1c60
%global abbrev %(c=%{commit}; echo ${c:0:8})

%global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1

%set_verify_elf_method unresolved=no
%add_debuginfo_skiplist %go_root %_bindir
%brp_strip_none %_bindir/* %go_root/bin/* %go_tooldir/*

Name:		golang-tools
Version:	0
Release:	alt8.git%abbrev
Summary:	Supplementary tools and packages for Go

Group:		Development/Other
License:	BSD
URL:		https://go.googlesource.com/tools

Packager:	Alexey Gladkov <legion@altlinux.ru>

Source0:	%name-%version.tar

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-build-golang

Requires:	golang

%description
The collection of developer tools.


%package devel
Summary: %summary
Group: Development/Other
BuildArch: noarch
Requires: golang

%description devel
%summary

This package contains library source intended for building other packages
which use the supplementary Go tools libraries with golang.org/x/ imports.


%prep
%setup -q

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GO111MODULE="auto"

%golang_prepare

rm -rf -- .build/src/%import_path/cmd/html2article
rm -rf -- .build/src/%import_path/cmd/present
rm -rf -- .build/src/%import_path/cmd/cover
rm -rf -- .build/src/%import_path/cmd/vet
rm -rf -- .build/src/%import_path/cmd/auth

cd .build/src/%import_path
%golang_build cmd/* ||:

%install
export BUILDDIR="$PWD/.build"
export GOPATH="%go_path"
export GO111MODULE="auto"

%golang_install

mkdir -p -- %buildroot/%go_root/bin
for f in %buildroot/%_bindir/*; do
	[ -x "$f" ] || continue
	f="${f##*/}"
	what="$(relative %_bindir/$f %go_root/bin/$f)"
	ln -s -- "$what" %buildroot/%go_root/bin/$f
done

# upstream commit 734737930440fc305a816e577cab457fbbc807c1 (rename oracle to guru)
# rm -f -- %buildroot/%_bindir/oracle
# ln -s -- guru %buildroot/%_bindir/oracle

# remove testdata, tests, and non-go files
find \
	%buildroot/%go_path/src \
	\( \
		\( -type d -name 'testdata'   \) -o \
		\( -type f -name 'Makefile'   \) -o \
		\( -type f -name '*_test.go'  \) -o \
		\( -type f -name 'test_*'     \) -o \
		\( -type f -name '*test.bash' \) -o \
		\( -type f -name 'test.'      \) \
	\) \
		-print0 |
	xargs -0 rm -rfv --

%files
%_bindir/*
%go_root/bin/*

%files devel
%go_path/src/*

%changelog
