Name: hardinfo
Version: 0.6
Release: alt0_0_git_b3c1f91

Epoch: 1
Summary: A system profiler for Linux
License: GPLv2+
Group: System/Kernel and hardware

Url: http://hardinfo.org
Source: %name-%version.tar
Patch0: 00-fix-cmake.patch
Patch1: 01-fix-impldecl.patch

BuildRequires(pre): cmake rpm-macros-cmake

BuildRequires: gcc-c++
BuildRequires: gettext-tools
BuildRequires: zlib-devel
BuildRequires: libpng-devel
BuildRequires: libgtk+3-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libXdamage-devel
BuildRequires: libXdmcp-devel
BuildRequires: libdrm-devel
BuildRequires: libexpat-devel
BuildRequires: libpixman-devel
BuildRequires: libharfbuzz-devel
BuildRequires: desktop-file-utils
BuildRequires: libsoup-devel
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: libsensors3-devel

Requires: pciids
Requires: pciutils
Requires: usbutils

%description
HardInfo is a system profiler for Linux systems.
It can display information about the hardware, software,
and perform simple benchmarks.

%prep
%setup
%autopatch -p1

%build
%cmake -DHARDINFO_GTK3=on \
	-DHARDINFO_NOSYNC=1

%cmake_build

%install
%cmakeinstall_std
%find_lang %name

desktop-file-install --vendor="" \
  --remove-category="Application" \
  --add-category="Settings;HardwareSettings;" \
  --dir %buildroot%_desktopdir %buildroot%_desktopdir/%name.desktop

%files -f %name.lang
%_bindir/%name
%dir %_libdir/%name
%dir %_libdir/%name/modules
%_libdir/%name/modules/*so
%_datadir/%name
%dir %_datadir/%name/doc
%doc %_datadir/%name/doc/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.*
%_desktopdir/%name.desktop

%changelog
