%define soversion 0
Name: inotify-tools
Version: 4.23.9.0
Release: alt2

Summary: Command line utilities for inotify
Group: System/Kernel and hardware
License: GPL-2.0-only
Url: https://github.com/rvoicilas/inotify-tools/wiki/
VCS: https://github.com/rvoicilas/inotify-tools
Source: %name-%version.tar
BuildRequires: doxygen gcc-c++

%description
inotify-tools is a set of command-line programs for Linux providing
a simple interface to inotify. These programs can be used to monitor
and act upon filesystem events.

%package -n libinotifytools
Summary: Shared library for inotifytools
Group: System/Libraries

%description -n libinotifytools
inotify-tools is a set of command-line programs for Linux providing
a simple interface to inotify. These programs can be used to monitor
and act upon filesystem events.

This is package contains shared library.

%package devel
Summary: Headers and libraries for building apps that use libinotifytools
Group: Development/C
Requires: libinotifytools = %version-%release

%description devel
inotify-tools is a set of command-line programs for Linux providing
a simple interface to inotify. These programs can be used to monitor
and act upon filesystem events.

This package contains headers and libraries required to build applications
that use the libinotifytools library.

%prep
%setup -q

%build
%autoreconf
%configure \
	--disable-static
%make_build

%check
make check

%install
%make_install DESTDIR=%buildroot install

rm -rf %buildroot%_datadir/doc/

%files
%doc AUTHORS NEWS
%_bindir/*
%_man1dir/*

%files -n libinotifytools
%_libdir/libinotifytools.so.%soversion.*
%_libdir/libinotifytools.so.%soversion

%files devel
%doc libinotifytools/src/doc/html/*
%_libdir/libinotifytools.so
%dir %_includedir/inotifytools
%_includedir/inotifytools/*.h

%changelog
