Name: iputils
Version: 20250605
Release: alt1

Summary: Utilities for IPv4/IPv6 networking
License: BSD-3-Clause and GPL-2.0+
Group: Networking/Other
Url: https://github.com/iputils/iputils

Source0: %name-%version.tar
Source1: ping.control
Patch: %name-%version-%release.patch

Conflicts: netkit-base

Requires(pre): shadow-utils
Requires(pre): control >= 0.8.0-alt1
Requires: /var/resolv

BuildRequires(pre): meson

BuildRequires: libcap-devel
BuildRequires: libidn2-devel
BuildRequires: docbook5-style-xsl xsltproc

%define _unpackaged_files_terminate_build 1

%define sysctl_conf_file %_sysctldir/70-iputils.conf
%define ping_real_dir %_usr/libexec/ping

%description
The iputils package contains basic utilities for monitoring a network:
+ clockdiff - measures clock difference;
+ ping - sends ICMP ECHO_REQUEST packets to network hosts;
+ arping - ping by ARP packets;
+ tracepath - traces path to destination discovering MTU along this path.

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing -Wstrict-prototypes
%ifnarch %e2k
%add_optflags -Werror -Wno-error=variadic-macros
%endif

%meson \
	-Dsystemdunitdir=%_unitdir \
	-DINSTALL_SYSTEMD_UNITS=true \
	-DNO_SETCAP_OR_SUID=true \
	-DUSE_CAP=true \
	-DUSE_IDN=true \
	-DUSE_GETTEXT=false \
	-DSKIP_TESTS=true

%meson_build -v

%install
%meson_install
mkdir -p %buildroot%ping_real_dir/
mv %buildroot%_bindir/ping %buildroot%ping_real_dir/
ln -s %ping_real_dir/ping %buildroot%_bindir/ping
ln -s %ping_real_dir/ping %buildroot%_bindir/ping6

install -pD -m755 %SOURCE1 %buildroot%_controldir/ping

mkdir -p %buildroot%_sysctldir/
touch %buildroot%sysctl_conf_file

ln -s tracepath %buildroot%_bindir/tracepath6
# for backward compatibility
mkdir -p %buildroot/bin/
ln -s %ping_real_dir/ping %buildroot/bin/ping
ln -s %ping_real_dir/ping %buildroot/bin/ping6
ln -s %_bindir/tracepath  %buildroot/bin/tracepath
ln -s tracepath %buildroot/bin/tracepath6

%pre
groupadd -r -f iputils ||:
useradd -r -g iputils -d /dev/null -s /dev/null -N iputils >/dev/null 2>&1 ||:
groupadd -r -f netadmin ||:

%pre_control ping

%post
# net.ipv4.ping_group_range controls both IPv4 and IPv6 sockets
if [ ! -e %sysctl_conf_file ]; then
	ALLOW_GID="$(getent group iputils | cut -f3 -d:)" ||:
	if [ -n "$ALLOW_GID" ]; then
		cat >%_sysctldir/70-iputils.conf <<EOF
# Allow ping socket creation for group iputils
net.ipv4.ping_group_range = $ALLOW_GID $ALLOW_GID
EOF
		sysctl -p %sysctl_conf_file ||:
	fi
fi

%post_control ping

%files
%config %_controldir/ping
%attr(700,root,netadmin) %verify(not mode) %dir %ping_real_dir/
%attr(2711,root,iputils) %ping_real_dir/ping
%ghost %config %sysctl_conf_file
/bin/*
%_bindir/*
%_sbindir/*
%_mandir/man?/*

%changelog
