# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
BuildRequires: /usr/bin/pod2man /usr/bin/pod2html
%global optflags_lto %nil
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major	2
%define libname	libcerf%{major}
%define devname	libcerf-devel

Name:		libcerf
Summary:	Complex error functions, Dawson, Faddeeva, and Voigt function
Version:	2.4
Release:	alt1_2
Group:		System/Libraries
License:	MIT
Url:		https://jugit.fz-juelich.de/mlz/libcerf
Source0:	https://jugit.fz-juelich.de/mlz/libcerf/-/archive/v%{version}/%{name}-v%{version}.tar.gz
BuildRequires:	ccmake cmake ctest
Source44: import.info

%description
A self-contained C library providing complex error functions, based on
Faddeeva's plasma dispersion function w(z).

Also provides Dawson's integral and Voigt's convolution of a Gaussian
and a Lorentzian.

%package -n %{libname}
Summary:	Complex error functions, Dawson, Faddeeva, and Voigt function
Group:		System/Libraries

%description -n %{libname}
A self-contained C library providing complex error functions, based on
Faddeeva's plasma dispersion function w(z).

Also provides Dawson's integral and Voigt's convolution of a Gaussian
and a Lorentzian.

%package -n %{devname}
Summary:	Development files for %{name}
Group:		Development/Other
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}

%description -n %{devname}
This package contains the development files for %{name}.

%prep
%setup -q -n %{name}-v%{version}


# Force cmake to use the paths passed at configure time
sed -i -e 's|lib/pkgconfig/|%{_lib}/pkgconfig/|' CMakeLists.txt
sed -i -e 's|DESTINATION lib|DESTINATION %{_lib}|' lib/CMakeLists.txt
sed -i -e 's|${prefix}/lib|@LIB_INSTALL_DIR@|' libcerf.pc.in
sed -i -e 's|@destination@|@CMAKE_INSTALL_PREFIX@|' libcerf.pc.in

# remove cruft
rm -rf fortran/__MACOSX

%build
%remove_optflags -frecord-gcc-switches
%{mageia_cmake}
%mageia_cmake_build

%install
%mageia_cmake_install

%check
%{mageia_ctest}

%files -n %{libname}
%doc CHANGELOG README*
%doc --no-dereference LICENSE
%{_libdir}/%{name}.so.%{major}
%{_libdir}/%{name}.so.%{version}

%files -n %{devname}
%doc %{_docdir}/cerf/
%{_includedir}/cerf.h
%{_libdir}/%{name}.so
%{_libdir}/cmake/cerf/
%{_libdir}/pkgconfig/%{name}.pc
%{_mandir}/man3/*


%changelog
