%define _unpackaged_files_terminate_build 1

Name: libfprint2
Version: 1.94.9
Release: alt1

Summary: Tool kit for fingerprint scanner
License: LGPLv2+
Group: System/Libraries

Url: https://fprint.freedesktop.org/
VCS: https://gitlab.freedesktop.org/libfprint/libfprint
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ cmake doxygen gtk-doc
BuildRequires: glib2-devel
BuildRequires: libXv-devel
BuildRequires: libcairo-devel
BuildRequires: libgio-devel
BuildRequires: libgusb-devel
BuildRequires: libssl-devel
BuildRequires: libpixman-devel
BuildRequires: libudev-devel
BuildRequires: libumockdev
BuildRequires: libusb-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libgusb-gir-devel
BuildRequires: libgudev-devel
BuildRequires: python3-module-pycairo
BuildRequires: python3-module-pygobject3
BuildRequires: /proc /dev/pts

%description
The fprint project aims to support for consumer fingerprint reader
devices.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.

%package tests
Summary: Installed tests for %name
Group: System/Libraries
Requires: %name = %EVR

%description tests
Installed tests for %name.

%prep
%setup
%patch -p1

%build
%meson -Ddrivers=all \
       -Dintrospection=true \
       -Dudev_rules=enabled \
       -Dgtk-examples=false \
       -Ddoc=false \
       -Dinstalled-tests=true
%meson_build

%install
%meson_install

%check
%__meson_test -t 100

%files
%doc COPYING INSTALL NEWS THANKS AUTHORS README.md
%_libdir/*.so.*
%_udevrulesdir/70-libfprint-2.rules
%_datadir/metainfo/org.freedesktop.libfprint.metainfo.xml

%files devel
%doc HACKING.md
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libfprint-2.pc

%files tests
%_datadir/installed-tests/libfprint-2
%_libexecdir/installed-tests/libfprint-2

%files gir
%_libdir/girepository-1.0/*.typelib

%files gir-devel
%_datadir/gir-1.0/*.gir

%changelog
