%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define api_ver 3.0

%def_enable ninja
%def_with bdb
%def_enable ical_glib
%def_enable introspection
%def_enable vala
%define __isa_bits %(s="%_lib"; s=${s#lib}; echo "${s:-32}")
%if "%__isa_bits" == "64"
# should be fixed in 3.0.20 but this is not important
%def_enable check
%else
%def_disable check
%endif
%def_enable docs
%def_with cxx

%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif

%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

%if "%altbranch" == "sisyphus" || "%altbranch" == "p11"
%def_with system_tzdata
%else
%def_without system_tzdata
%endif

Name: libical
Version: 3.0.20
Release: alt1

Summary: An implementation of basic iCAL protocols
Group: System/Libraries
License: LGPL-2.1-only or MPL-2.0
Url: https://github.com/%name

Vcs: https://github.com/libical/libical.git

%if_disabled snapshot
Source: %url/%name/releases/download/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define tzdata_ver 2024a
%define glib_ver 2.38
%define xml2_ver 2.7.3
%{?_with_system_tzdata:Requires: tzdata >= %tzdata_ver}

BuildRequires(pre): rpm-macros-cmake %{?_enable_introspection:rpm-build-gir} %{?_enable_vala:rpm-build-vala}
BuildRequires: cmake gcc-c++ gtk-doc libicu-devel icu-utils
%{?_enable_ninja:BuildRequires: ninja-build}
%{?_with_system_tzdata:BuildRequires: tzdata >= %tzdata_ver}
%{?_with_bdb:BuildRequires: libdb4-devel}
%{?_enable_ical_glib:BuildRequires: libgio-devel >= %glib_ver libxml2-devel >= %xml2_ver}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_check:BuildRequires: ctest python3-module-pygobject3}

%description
Libical is an Open Source implementation of the IETF's iCalendar
Calendaring and Scheduling protocols (RFC 2445, 2446, and 2447).
It parses iCal components and provides a C API for manipulating the
component properties, parameters, and subcomponents

%package devel
Summary: Files for developing applications that use libical
Group: Development/C
Requires: %name = %EVR
# since 2.0.0
Requires: libicu-devel

%description devel
The header files and libtool library for developing applications that use
libical.

%package gir
Summary: GObject introspection data for the Libical
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Libical library.

%package gir-devel
Summary: GObject introspection devel data for the Libical
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the Libical library.

%package -n %name-glib
Summary: A GObject interface of the libical library
Group: System/Libraries
Requires: %name = %EVR

%description -n %name-glib
This package provides Libical-Glib library with GObject bindings to
libical library.

%package -n %name-glib-devel
Summary: Files for developing applications that use Libical-Glib
Group: Development/C
Requires: %name-glib = %EVR
Requires: %name-devel = %EVR

%description -n %name-glib-devel
The header files and libtool library for developing applications that use
Libical-Glib.

%package -n %name-glib-gir
Summary: GObject introspection data for the Libical-Glib
Group: System/Libraries
Requires: %name-glib = %EVR

%description -n %name-glib-gir
GObject introspection data for the Libical-Glib library.

%package -n %name-glib-gir-devel
Summary: GObject introspection devel data for the Libical-Glib
Group: Development/Other
BuildArch: noarch
Requires: %name-glib-gir = %EVR
Requires: %name-glib-devel = %EVR

%description -n %name-glib-gir-devel
GObject introspection devel data for the Libical-Glib library.

%package -n %name-glib-devel-doc
Summary: Development documentation for Libical-Glib
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-glib-devel < %version-%release

%description -n %name-glib-devel-doc
This package contains development documentation for the Libical-Glib
library.

%prep
%setup
#src/libical/icaltz-util.h:#define ZONES_TAB_SYSTEM_FILENAME "zone.tab"
%{?_with_system_tzdata:sed -i 's|zone.tab|zone1970.tab|' src/libical/icaltz-util.h}

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
	%{?_enable_ninja:-GNinja} \
	-DCMAKE_BUILD_TYPE:STRING="Release" \
	-DSHARED_ONLY:BOOL=ON \
	%{?_with_cxx:-DWITH_CXX_BINDINGS:BOOL=ON} \
	%{?_enable_ical_glib:-DICAL_GLIB:BOOL=ON} \
	%{?_enable_introspection:-DGOBJECT_INTROSPECTION:BOOL=ON} \
	%{?_enable_vala:-DICAL_GLIB_VAPI=ON} \
	%{?_disable_docs:-DICAL_BUILD_DOCS:BOOL=OFF} \
	%{?_with_system_tzdata:-DUSE_BUILTIN_TZDATA:BOOL=OFF}
%nil
%cmake_build

%install
%cmake_install

%check
%cmake_build -t test

%files
%_libdir/libical.so.*
%_libdir/libicalss.so.*
%_libdir/libicalvcal.so.*
%if_with cxx
%_libdir/libical_cxx.so.*
%_libdir/libicalss_cxx.so.*
%endif
%doc TODO TEST THANKS ReleaseNotes.txt README*

%files devel
%_includedir/%name/
%_libdir/libical.so
%_libdir/libicalss.so
%_libdir/libicalvcal.so
%if_with cxx
%_libdir/libical_cxx.so
%_libdir/libicalss_cxx.so
%endif
%_pkgconfigdir/%name.pc
%_libdir/cmake/LibIcal/
%doc doc/UsingLibical*

%files -n %name-glib
%_libdir/%name-glib.so.*

%files -n %name-glib-devel
%_libexecdir/%name/ical-glib-src-generator
%_includedir/%name-glib/
%_libdir/%name-glib.so
%_pkgconfigdir/%name-glib.pc
%{?_enable_vala:%_vapidir/*}

%if_enabled introspection
%files gir
%_typelibdir/ICal-%api_ver.typelib

%files gir-devel
%_girdir/ICal-%api_ver.gir

%files -n %name-glib-gir
%_typelibdir/ICalGLib-%api_ver.typelib

%files -n %name-glib-gir-devel
%_girdir/ICalGLib-%api_ver.gir
%endif

%if_enabled docs
%files -n %name-glib-devel-doc
%_datadir/gtk-doc/html/%name-glib/
%endif


%changelog
