%def_disable snapshot

%def_enable fastfloat
%def_enable threaded
%def_enable utils
%def_disable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}

%def_enable check

%define rname lcms2

Name: lib%rname
Version: 2.17
Release: alt1

Summary: Little cms color engine, version 2
License: MIT or GPL-3.0
Group: System/Libraries
Url: http://www.littlecms.com

Vcs: https://github.com/mm2/Little-CMS.git

%if_disabled snapshot
Source: http://downloads.sourceforge.net/lcms/%rname-%version.tar.gz
%else
Source: %rname-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++
BuildRequires: libjpeg-devel libtiff-devel zlib-devel

%package devel
Summary: LCMS 2 development environment
Group: Development/C
Requires: %name = %EVR

%if_enabled static
%package devel-static
Summary: Static LCMS 2 library
Group: Development/C
Requires: %name-devel = %EVR
%endif

%package -n lcms2-utils
Summary: Various %name-based utilities
Group: Graphics
Requires: %name = %EVR

%description
This is a CMM engine to deal with color management stuff.

This package contains the library needed to run programs dynamically
linked with %name.

%description devel
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
applications which requires the LCMS 2 library.

%if_enabled static
%description devel-static
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
statically linked applications which requires the LCMS 2 library.
%endif

%description -n lcms2-utils
This is a CMM engine to deal with color management stuff.

This package contains various %name-based utilities

%prep
%setup -n %rname-%version

%build
%meson \
    %{?_enable_static:--default-library=both} \
    %{subst_enable_meson_bool threaded  threaded} \
    %{subst_enable_meson_bool fastfloat fastfloat} \
    %{subst_enable_meson_bool utils utils}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/%{name}*.so.*
%doc AUTHORS README*

%if_enabled utils
%files -n lcms2-utils
%_bindir/jpgicc
%_bindir/linkicc
%_bindir/psicc
%_bindir/tificc
%_bindir/transicc
%_man1dir/*
%endif

%files devel
%_includedir/*
%_libdir/%{name}*.so
%_pkgconfigdir/%rname.pc

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
