Name: libleveldb
Version: 1.23
Release: alt1

Summary: A fast and lightweight key/value database library by Google

License: BSD
Group: Development/Databases
Url: https://github.com/google/leveldb

Packager: Alexei Takaseev <taf@altlinux.ru>

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

## patches from Fedora
Patch0001: 0001-Allow-leveldbjni-build.patch
Patch0002: 0002-Added-a-DB-SuspendCompations-and-DB-ResumeCompaction.patch
Patch0003: 0003-allow-Get-calls-to-avoid-copies-into-std-string.patch
Patch0004: 0004-bloom_test-failure-on-big-endian-archs.patch
Patch0006: 0006-revert-no-rtti.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: libsnappy-devel
# Can't build ceph with external crc32c libs
#BuildRequires: libcrc32c-devel

%description
LevelDB is a fast key-value storage library written at Google that provides an
ordered mapping from string keys to string values.

%package devel
Summary: The development files for %name
Group: Development/Databases
Requires: %name = %version-%release

%description devel
Additional header files for development with %name.

%prep
%setup
%autopatch -p1

cat > leveldb.pc << EOF
prefix=%prefix
exec_prefix=%prefix
libdir=%_libdir
includedir=%_includedir

Name: leveldb
Description: %summary
Version: %version
Libs: -lleveldb
EOF

%build
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DLEVELDB_BUILD_TESTS:BOOL=OFF \
	-DLEVELDB_BUILD_BENCHMARKS:BOOL=OFF
%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_pkgconfigdir
cp -a leveldb.pc %buildroot%_pkgconfigdir/

%files
%doc AUTHORS LICENSE README.md
%_libdir/%name.so.*

%files devel
%doc doc
%_includedir/leveldb
%_libdir/%name.so
%_pkgconfigdir/*
%_libdir/cmake/leveldb

%changelog
