%define _unpackaged_files_terminate_build 1
# Suppress warning emerging from mentioning this macro in changelog
%define _sysconfigdir /etc

# Enable cmake RPATH for unit tests
%global _cmake_skip_rpath %nil

%def_enable test

Name: libnss-role
Version: 0.5.6
Release: alt4

Summary: NSS API library and admin tools for roles and privilegies

License: LGPLv2.1
URL: https://github.com/altlinux/libnss-role
Group: System/Libraries

Packager: Vitaly Lipatov <lav@altlinux.ru>

# https://github.com/altlinux/libnss-role.git
Source: %name-%version.tar

BuildRequires: glibc-devel
BuildRequires: cmake
BuildRequires: libpam0-devel
BuildRequires: nss_wrapper

%if_enabled test
BuildRequires: ctest
BuildRequires: libcmocka-devel
%endif

Requires: libpam0 chrooted >= 0.3.5-alt1 chrooted-resolv control

%description
NSS API library and admin tools for roles and privilegies.

%package devel
Summary: Header for developing applications managing Roles
Group: Development/Other
Requires: %name = %version-%release

%description devel
Headers for developing applications managing Roles throw
NSS API library for roles and privilegies.

%prep
%setup

%build
%cmake \
%if_enabled test
	-DENABLE_TESTS=ON \
%else
	-DENABLE_TESTS=OFF \
%endif
	-DNSS_LIBDIR=/%_lib \
	-DROLE_LIBDIR=%_libdir \
	-DMANDIR=%_man8dir \
	-DCMAKE_INSTALL_PREFIX:PATH=%_prefix
%cmake_build
%if_enabled test
%cmake_build -t all_tests
%endif

%if_enabled test
%check
%cmake_build -- all_tests
%_cmake__builddir/checkver %version
%endif

%install
%cmakeinstall_std
mkdir -p %buildroot%_sysconfdir/role.d

# control support
install -pD -m755 %name.control %buildroot%_controldir/%name

%post
if [ $1 -eq 1 ]; then
	control libnss-role enabled
	update_chrooted all
fi

%preun
if [ $1 -eq 0 ]; then
	control libnss-role disabled
	update_chrooted all
fi

%triggerun -- libnss-role < 0.5.6-alt4
%pre_control libnss-role

%triggerpostun -- libnss-role < 0.5.6-alt4
%post_control libnss-role

%files
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/role
%dir %_sysconfdir/role.d
%_sysconfdir/pam.d/role*
/%_lib/libnss_*.so.*
%_sbindir/roleadd
%_sbindir/roledel
%_bindir/rolelst
%_libdir/*.so.*
%_man8dir/*
%config %_controldir/%name

%files devel
%_libdir/*.so
%_includedir/role/

%changelog
