%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: lkrg
Version: 0.9.9
Release: alt1

Summary: Linux Kernel Runtime Guard module

License: GPL-2.0
Group: System/Configuration/Other
Url:  https://lkrg.org/

VCS: https://github.com/lkrg-org/lkrg.git
Source: %name-%version.tar
Source1: %name.init

ExclusiveArch: aarch64 armh %ix86 x86_64
BuildRequires(pre): rpm-build-kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires: kernel-headers-modules-un-def
BuildRequires: shellcheck
}}
Requires: lkrg-common

%description
Linux Kernel Runtime Guard (LKRG) is a loadable kernel module that performs
runtime integrity checking of the Linux kernel and detection of security
vulnerability exploits against the kernel. As controversial as this concept is,
LKRG attempts to post-detect and hopefully promptly respond to unauthorized
modifications to the running Linux kernel (integrity checking) or to
credentials (such as user IDs) of the running processes (exploit
detection). For process credentials, LKRG attempts to detect the exploit and
take action before the kernel would grant the process access (such as open a
file) based on the unauthorized credentials.

%package -n kernel-source-lkrg
Summary: This package contains the LKRG sources
BuildArch: noarch
Group: Development/Kernel

%description -n kernel-source-lkrg
%summary.

%package common
Summary: Common files for Linux Kernel Runtime Guard module
BuildArch: noarch
Group: System/Configuration/Other
Provides: lkrg-config = %version
Obsoletes: lkrg-config < %version

%description common
Linux Kernel Runtime Guard (LKRG) is a loadable kernel module that performs
runtime integrity checking of the Linux kernel and detection of security
vulnerability exploits against the kernel. As controversial as this concept is,
LKRG attempts to post-detect and hopefully promptly respond to unauthorized
modifications to the running Linux kernel (integrity checking) or to
credentials (such as user IDs) of the running processes (exploit
detection). For process credentials, LKRG attempts to detect the exploit and
take action before the kernel would grant the process access (such as open a
file) based on the unauthorized credentials.

This package contains common files for Linux Kernel Runtime Guard.

%package logger
Summary: LKRG remote logging receiving tools
Group: System/Servers

%description logger
LKRG supports optional remote kernel message logging.  Once enabled, this logs
not only messages generated by LKRG, but also all other kernel messages.

The sending component is in the LKRG kernel module itself, whereas the
receiving and logging counterpart is in a userspace daemon.  There are also
additional userspace utilities.

%prep
%setup -c
cp -a %SOURCE1 .

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build -C %name-%version/logger LDFLAGS="" CFLAGS="%optflags"

%install
mkdir -p %kernel_srcdir
tar -cjf %kernel_srcdir/kernel-source-%name-%version.tar.bz2 %name-%version
mkdir -p %buildroot%_sysconfdir
cp -a %name-%version/scripts/bootup/lkrg.conf %buildroot%_sysconfdir/lkrg.conf

mkdir -p %buildroot%_initdir
install -pm755 lkrg.init %buildroot%_initdir/lkrg

mkdir -p %buildroot%_unitdir
cat <<EOF >%buildroot%_unitdir/lkrg.service
[Unit]
Description=Linux Kernel Runtime Guard
DefaultDependencies=no
After=systemd-modules-load.service
Before=systemd-sysctl.service
Before=sysinit.target shutdown.target
Conflicts=shutdown.target
ConditionKernelCommandLine=!nolkrg

[Service]
Type=oneshot
ExecStart=/etc/rc.d/init.d/lkrg start
ExecStop=/etc/rc.d/init.d/lkrg stop
RemainAfterExit=yes

[Install]
WantedBy=sysinit.target
EOF

mkdir -p %buildroot%_presetdir
cat <<EOF >%buildroot%_presetdir/30-lkrg.preset
enable lkrg.service
EOF

%makeinstall_std -C %name-%version/logger PREFIX=%_usr UNITDIR=%_unitdir
mkdir -p %buildroot%_logdir/lkrg-logger
touch %buildroot%_sysconfdir/lkrg-logger.conf

%check
bash -n lkrg.init
shellcheck -x lkrg.init

# Just a test build on un-def kernel.
cd %name-%version
for V in $(ls /lib/modules); do
	make -s %_smp_mflags KERNELRELEASE=$V
done

%triggerun common -- lkrg-config < 0.9.2.0.1.git10ba314-alt2 lkrg-common < 0.9.2.0.1.git10ba314-alt2
if [ -e %_sysconfdir/sysctl.d/lkrg.conf ]; then
	echo "Migrating an LKRG config to the new place"
	if ! diff -q %_sysconfdir/{,sysctl.d/}lkrg.conf >/dev/null; then
		mv %_sysconfdir/lkrg.conf{,.rpmnew}
	fi
	mv %_sysconfdir/sysctl.d/lkrg.conf %_sysconfdir/lkrg.conf
fi

%preun common
%preun_service lkrg

%pre -n kernel-source-lkrg
[ -d /.host -a -d /.in -a -d /.out ] || {
	echo >&2 '%name is not allowed outside hasher environments'
	exit 1
}

%post logger
groupadd -r lkrg-logger
useradd -r lkrg-logger -g lkrg-logger -d /var/empty -s /dev/null
test $1 -eq 1 && ! test -s %_sysconfdir/lkrg-logger.conf && lkrg-keygen > %_sysconfdir/lkrg-logger.conf
%post_service lkrg-logger

%preun logger
%preun_service lkrg-logger

%files -n kernel-source-lkrg
%attr(0644,root,root) %kernel_src/kernel-source-%name-%version.tar.bz2

%files common
%config(noreplace) %_sysconfdir/lkrg.conf
%_initdir/lkrg
%_unitdir/lkrg.service
%_presetdir/30-lkrg.preset

%files logger
%attr(0750,lkrg-logger,lkrg-logger) %dir %_logdir/lkrg-logger
%attr(0600,root,root) %config(noreplace) %_sysconfdir/lkrg-logger.conf
%_sbindir/lkrg-keygen
%_sbindir/lkrg-logctl
%_sbindir/lkrg-logger
%_unitdir/lkrg-logger.service

%changelog
