Name: make-initrd
Version: 2.55.1
Release: alt5

Summary: Creates an initramfs image
License: GPL-3.0
Group: System/Base
Url: https://github.com/osboot/make-initrd
Vcs: https://github.com/osboot/make-initrd.git

Packager: Alexey Gladkov <legion@altlinux.ru>

%define _unpackaged_files_terminate_build 1
%add_verify_elf_skiplist %_libdir/initrd/*
%add_findreq_skiplist %_libdir/initrd/*
%add_debuginfo_skiplist %_libdir/initrd/*

%def_with iscsi

BuildRequires: autoconf
BuildRequires: udev
BuildRequires: flex
BuildRequires: bison
BuildRequires: scdoc
BuildRequires: pkgconfig(libkmod)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(libzstd)
BuildRequires: pkgconfig(libelf)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(libtirpc)

Provides: make-initrd(crc32c) = 1

Provides: mkinitrd = 2:%version-%release

Provides: make-initrd2 = %version-%release
Obsoletes: make-initrd2

Provides: kinit-utils = %version-%release
Obsoletes: kinit-utils

Provides: make-initrd-busybox = %version-%release
Obsoletes: make-initrd-busybox

Requires: bash libshell make sed module-init-tools coreutils findutils grep glibc-utils
Requires: chrooted-resolv service util-linux

# Feature qemu
Requires: pciutils

# depinfo
Requires: libkmod >= 8-alt1

# make bug-report
Requires: tar

# Move /dev from initrd to the real system.
# 167: udevadm info --run
Requires: udev >= 167-alt1

# blkid
Requires: util-linux >= 2.17.2-alt1

# tools/pack-image
Requires: cpio

# This avoids getting a dependency on sh from "#!/bin/sh".
#AutoReq: yes, nopam, noperl, nopython, noshell, notcl
AutoReq: noshell, noshebang

Source0: %name-%version.tar
Patch: 0001-feature-runtime-Check-and-create-the-necessary-devic.patch
Patch1: 0002-guess-device-tree-fix-typo-in-the-variable-name-moda.patch
Patch2: 0003-feature-modules-virtio-Fix-symbol-filter.patch

%description
make-initrd is a new, uevent-driven initramfs infrastructure based around udev.


%package devmapper
Summary: device-mapper module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: dmsetup >= 1.02.44-alt3
AutoReq: noshell, noshebang

%description devmapper
device-mapper module for %name


%package lvm
Summary: LVM module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: lvm2
AutoReq: noshell, noshebang

%description lvm
LVM module for %name


%package luks
Summary: LUKS module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: cryptsetup
AutoReq: noshell, noshebang

%description luks
LUKS module for %name


%package nfs
Summary: NFS module for %name
Group: System/Base
BuildArch: noarch
AutoReq: noshell, noshebang

%description nfs
NFS module for %name


%package multipath
Summary: multipath module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: multipath-tools
AutoReq: noshell, noshebang

%description multipath
Multipath module for %name


%package plymouth
Summary: plymouth module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: plymouth
Requires: plymouth-plugin-label
Requires: fonts-ttf-dejavu
Requires: fontconfig
AutoReq: noshell, noshebang

%description plymouth
plymouth module for %name


%package mdadm
Summary: mdadm module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: mdadm
AutoReq: noshell, noshebang

%description mdadm
Mdadm module for %name


%package ucode
Summary: CPU microcode module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: iucode_tool, firmware-intel-ucode, linux-firmware
Requires: cpio
AutoReq: noshell, noshebang

%description ucode
CPU microcode autoloading module for %name


%if_with iscsi
%package iscsi
Summary: iSCSI module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: open-iscsi
AutoReq: noshell, noshebang

%description iscsi
iSCSI module for %name
%endif


%package kickstart
Summary: kickstart module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: btrfs-progs coreutils e2fsprogs eject mount rsync sfdisk tar unzip util-linux wget
AutoReq: noshell, noshebang

%description kickstart
Kickstart module for %name


%package sshfs
Summary: sshfs module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: fuse-sshfs
AutoReq: noshell, noshebang

%description sshfs
Feature adds the ability to mount the root using SSH (more precisely, the SFTP
subsystem). Most SSH servers support and enable this SFTP access by default, so
SSHFS is very simple to use.


%package smartcard
Summary: smart-card module for %name
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: opensc
Requires: pcsc-lite
Requires: pcsc-tools
AutoReq: noshell, noshebang

%description smartcard
Feature adds smart card daemon and smart card utilities.


%package bootconfig
Summary: Extra Boot Config (XBC) support for %name
Group: System/Base
Requires: %name = %version-%release
Requires: linux-tools >= 5.14-alt2
AutoReq: noshell, noshebang

%description bootconfig
Extra Boot Config (XBC) support for %name.


%package zfs
Summary: Bootloader feature for %name
Group: System/Base
Requires: %name = %version-%release
Requires: zfs-utils
AutoReq: noshell, noshebang

%description zfs
Make-initrd OpenZFS feature.


%package guestfs
Summary: guestfs feature for %name
BuildArch: noarch
Group: System/Base
Requires: %name = %version-%release
Requires: file mount rsync
Requires: fdisk sfdisk gdisk parted zerofree
Requires: binutils gzip-utils nfs-utils mdadm-tool
Requires: e2fsprogs guestfsd xfsprogs reiserfsprogs
Requires: btrfs-progs dosfstools jfsutils fuse ntfs-3g
AutoReq: noshell, noshebang

%description guestfs
Make-initrd guestfs feature.


%define _libexecdir %_prefix/libexec

%prep
%setup -q
%autopatch -p1

%build
./autogen.sh
%configure \
	--libexecdir=%_libexecdir \
	--with-bootdir=/boot \
	--with-runtimedir=%_libdir/initrd \
	--with-imagename='initrd-$(KERNEL)$(IMAGE_SUFFIX).img' \
	--with-busybox \
	--with-libelf \
	--with-zlib \
	--with-bzip2 \
	--with-lzma \
	--with-zstd \
	#

%ifnarch %{ix86} x86_64
sed -r -i \
	-e 's/^(CONFIG_SHA1_HWACCEL)=y/# \1 is not set/' \
	-e 's/^(CONFIG_SHA256_HWACCEL)=y/# \1 is not set/' \
	external/busybox/config
%endif

make

%install
%make_install DESTDIR=%buildroot install

%triggerin -- %name < 0.8.1-alt1
c="%_sysconfdir/initrd.mk"
if [ -s "$c" ] && ! grep -qs '^AUTODETECT[[:space:]]*=[[:space:]]*all[[:space:]]*' "$c"; then
	printf -- 'make-initrd: Migrating to new autodetect scheme ...\n' >&2
	sed -i -e 's/^\(AUTODETECT[[:space:]]*=.*\)$/# \1\nAUTODETECT = all/' "$c"
fi

%post
if [ -d "%_localstatedir/initrd" ]; then
		rm -rf -- %_localstatedir/initrd
fi

%files
%dir %_sysconfdir/initrd.mk.d
%config(noreplace) %_sysconfdir/initrd.mk.d/*.mk.example
%exclude %_sysconfdir/initrd.mk.d/guestfs.mk.example
%config(noreplace) %_sysconfdir/initrd.mk
%_bindir/*
%_sbindir/*
%_datadir/%name
%_man1dir/*
%_libdir/initrd
%exclude %_datadir/%name/features/devmapper
%exclude %_datadir/%name/features/lvm
%exclude %_datadir/%name/features/luks
%exclude %_datadir/%name/features/luks-unl0kr
%exclude %_datadir/%name/features/nfsroot
%exclude %_datadir/%name/features/multipath
%exclude %_datadir/%name/features/plymouth
%exclude %_datadir/%name/features/mdadm
%exclude %_datadir/%name/features/ucode
%exclude %_datadir/%name/guess/ucode
%exclude %_datadir/%name/features/kickstart
%exclude %_datadir/%name/guess/smart-card
%exclude %_datadir/%name/features/sshfsroot
%exclude %_datadir/%name/features/smart-card
%exclude %_datadir/%name/features/bootconfig
%exclude %_datadir/%name/features/zfs
%exclude %_datadir/%name/features/guestfs
%{?_with_iscsi:%exclude %_datadir/%name/features/iscsi}
%doc Documentation/*.md

%files devmapper
%_datadir/%name/features/devmapper

%files lvm
%_datadir/%name/features/lvm

%files luks
%_datadir/%name/features/luks
%_datadir/%name/features/luks-unl0kr

%files nfs
%_datadir/%name/features/nfsroot

%files multipath
%_datadir/%name/features/multipath

%files plymouth
%_datadir/%name/features/plymouth

%files mdadm
%_datadir/%name/features/mdadm

%ifarch %ix86 x86_64
%files ucode
%_datadir/%name/features/ucode
%_datadir/%name/guess/ucode
%endif

%if_with iscsi
%files iscsi
%_datadir/%name/features/iscsi
%endif

%files kickstart
%_datadir/%name/features/kickstart

%files sshfs
%_libexecdir/%name/features/sshfsroot
%_datadir/%name/features/sshfsroot

%files smartcard
%_datadir/%name/guess/smart-card
%_datadir/%name/features/smart-card

%ifnarch %e2k
%files bootconfig
%_datadir/%name/features/bootconfig
%endif

%ifnarch %e2k
%files zfs
%_datadir/%name/features/zfs
%endif

%ifnarch %e2k
%files guestfs
%_datadir/%name/features/guestfs
%config(noreplace) %_sysconfdir/initrd.mk.d/guestfs.mk.example
%endif

%changelog
