%define ver_major 1.0

Name: mm-common
Version: %ver_major.6
Release: alt1

Summary: Common build files of the C++ bindings
Group: Development/Tools
License: GPL-2.0
Url: http://gtkmm.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

BuildRequires(pre): rpm-macros-meson >= 0.55 rpm-build-python3
BuildRequires: meson
%add_python3_path %_datadir/%name/build

%description
The mm-common module provides the build infrastructure and utilities
shared among the GNOME C++ binding libraries. It is only a required
dependency for building the C++ bindings from the gnome.org version
control repository. An installation of mm-common is not required for
building tarball releases, unless configured to use maintainer-mode.

%package docs
Summary: Documentation for %name, includes example mm module skeleton
Group: Development/C++
Requires: %name = %version-%release

%description docs
Package contains short documentation for %name and example skeleton module,
which could be used as a base for new mm module.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/*
%_datadir/%name/
%_datadir/aclocal/*.m4
%_datadir/pkgconfig/%name-libstdc++.pc
%_datadir/pkgconfig/%name-util.pc
%_man1dir/*
%doc ChangeLog NEWS

%files docs
%dir %_docdir/%name
%_docdir/%name/*

%changelog
