%def_enable translation

%define sover 0
%define libxnvctrl libxnvctrl%sover

Name: nvidia-settings
Version: 580.82.07
Release: alt1

Group: System/Configuration/Hardware
Summary: Tool for configuring the NVIDIA driver
Url: ftp://download1.nvidia.com/XFree86/nvidia-settings/
License: GPL-2.0-only

Source: %name-%version.tar.gz
Source4: nvidia-settings-load.sh
Source5: nvidia-settings.desktop
Source6: nvidia-settings-load.desktop
Source100: gettext.h
Source101: ru.po

Patch1: xlibs.patch
Patch2: cflags.patch
Patch3: alt-ui-modules-dir.patch
Patch4: add-error-popup.patch
Patch5: libxnvctrl_so_0.patch
Patch100: nvidia-settings-440.59-alt-integrate-translation.patch

# Automatically added by buildreq on Mon May 13 2013 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libGL-devel libX11-devel libXext-devel libXrender-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libwayland-client libwayland-server pkg-config python-base xorg-randrproto-devel xorg-renderproto-devel xorg-videoproto-devel xorg-xextproto-devel xorg-xf86vidmodeproto-devel xorg-xproto-devel
#BuildRequires: libXrandr-devel libXv-devel libXxf86vm-devel libgtk+2-devel libvdpau-devel ruby ruby-stdlibs
BuildRequires: rpm-build-xdg
BuildRequires: libXrandr-devel libXv-devel libXxf86vm-devel libGL-devel libvdpau-devel
BuildRequires: libwayland-client-devel
BuildRequires: libdbus-devel
BuildRequires: libgtk+3-devel
BuildRequires: libvulkan-devel
BuildRequires: libjansson-devel
BuildRequires: /usr/bin/convert

%description
The `nvidia-settings` utility is a tool for configuring the NVIDIA
Linux graphics driver.  It operates by communicating with the NVIDIA
X driver, querying and updating state as appropriate.  This
communication is done with the NV-CONTROL X extension.

Values such as brightness and gamma, XVideo attributes, temperature,
and OpenGL settings can be queried and configured via nvidia-settings.

When nvidia-settings starts, it reads the current settings from
its configuration file and sends those settings to the X server.
Then, it displays a graphical user interface (GUI) interface for
configuring the current settings.  When nvidia-settings exits, it
queries the current settings from the X server and saves them to
the configuration file.

%package -n libxnvctrl-devel
Group: Development/Other
Summary: Development files for %name
Provides: nvidia-settings-devel = %EVR libXNVCtrl-devel = %EVR
Obsoletes: nvidia-settings-devel < %EVR libXNVCtrl-devel < %EVR
%description -n libxnvctrl-devel
Development files for %name

%package -n %libxnvctrl
Group: System/Libraries
Summary: Development files for %name
Provides: libXNVCtrl = %EVR
Obsoletes: libXNVCtrl < %EVR
%description -n %libxnvctrl
This library provides the NV-CONTROL API for communicating with
the proprietary NVIDIA driver.

%prep
%setup
#%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p1
%if_enabled translation
mkdir -p po/msg
#%patch100 -p1
install -p -m644 %SOURCE100 src/gtk+-2.x/gettext.h
install -p -m644 %SOURCE101 po/msg/ru.po
%endif

rm -rf src/jansson
sed -i 's|@GUI_LIB_PREFIX@|%_libdir/nvidia-settings|' src/nvidia-settings.c
sed -i -E 's|LIBDIR[[:space:]]+=[[:space:]].*|LIBDIR = $(DESTDIR)$(PREFIX)/%_lib|' utils.mk

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%add_optflags %optflags_shared
NV_BUILD_OPTS="PREFIX=%prefix NV_VERBOSE=1 DEBUG=1 NV_KEEP_UNSTRIPPED_BINARIES=1 NV_USE_BUNDLED_LIBJANSSON=0"
%make_build CFLAGS="%optflags"       $NV_BUILD_OPTS -C src/libXNVCtrl
%make_build LOCAL_CFLAGS="%optflags" $NV_BUILD_OPTS
%make_build CFLAGS="%optflags"       $NV_BUILD_OPTS -C src/libXNVCtrl libXNVCtrl.so

%install
make install DESTDIR=%buildroot PREFIX=%prefix bindir=%buildroot/%_bindir mandir=%buildroot/%_man1dir NV_USE_BUNDLED_LIBJANSSON=0
# cleanup
rm -f %buildroot/%_libdir/libnvidia-wayland-client.* ||:

#mkdir -p %buildroot/%_bindir
#install -m 0755 nvidia-settings %buildroot/%_bindir

for p in %buildroot/%_libdir/%name/* ; do
    new_path=`echo "$p" | sed 's|\.so\..*|.so|'`
    [ "$p" == "$new_path" ] \
	|| ln -s `basename $p` $new_path
done

install -m 0755 %SOURCE4 %buildroot/%_bindir/
mkdir -p %buildroot/%_xdgconfigdir/autostart/
install -m 0644 %SOURCE6 %buildroot/%_xdgconfigdir/autostart/

for sz in 16x16 32x32 48x48 64x64 128x128 ; do
    mkdir -p %buildroot/%_iconsdir/hicolor/$sz/apps/
    convert doc/nvidia-settings.png -resize $sz %buildroot/%_iconsdir/hicolor/$sz/apps/%name.png
done

mkdir -p %buildroot/%_desktopdir
install -m 0644 %SOURCE5 %buildroot/%_desktopdir/

mkdir -p %buildroot/%_libdir
#install -m 0644 src/_out/Linux_*/libXNVCtrl.a %buildroot/%_libdir/
cp -ar src/libXNVCtrl/libXNVCtrl.so* %buildroot/%_libdir/

mkdir -p %buildroot/%_includedir/NVCtrl/
install -m 0644 src/libXNVCtrl/*.h %buildroot/%_includedir/NVCtrl/

%find_lang %name

%files -f %name.lang
%doc doc/*.txt
%_man1dir/%name.*
%_bindir/%name
%_bindir/%name-load.sh
%_libdir/%name/*gtk3*.so*
%_desktopdir/%name.desktop
%_xdgconfigdir/autostart/%name-load.desktop
%_iconsdir/*/*/apps/%name.png

%files -n %libxnvctrl
%_libdir/libXNVCtrl.so.%sover
%_libdir/libXNVCtrl.so.*

%files -n libxnvctrl-devel
%doc doc/FRAMELOCK.txt doc/NV-CONTROL-API.txt samples/README samples/*.{c,h}
%_includedir/NVCtrl/
%_libdir/lib*.so
#%_libdir/lib*.a

%changelog
