%define _unpackaged_files_terminate_build 1

%global backends %nil
%define _pkgdocdir %_docdir/%name

Name: pdns
Version: 4.9.1
Release: alt1
Summary: A modern, advanced and high performance authoritative-only nameserver
Group: System/Servers
License: GPLv2
Url: http://powerdns.com
Source0: %name-%version.tar
Patch4: %name-4.2.2-alt-fix-missing-include.patch
ExcludeArch: %ix86 %arm %mips32 ppc

BuildRequires: gcc-c++ boost-program_options-devel curl libcurl-devel libsqlite3-devel
BuildRequires: systemd-devel systemd
BuildRequires: boost-devel
BuildRequires: liblua5-devel
BuildRequires: bison flex ragel
BuildRequires: libzeromq-devel
BuildRequires: libssl-devel libsodium-devel
BuildRequires: libprotobuf-devel protobuf-compiler
BuildRequires: libkrb5-devel
Provides: powerdns = %version-%release
%global backends %backends bind

Obsoletes: pdns-backend-lua < 4.6.3
Obsoletes: pdns-backend-mydns < 4.6.3

%description
The PowerDNS Nameserver is a modern, advanced and high performance
authoritative-only nameserver. It is written from scratch and conforms
to all relevant DNS standards documents.
Furthermore, PowerDNS interfaces with almost any database.

%package tools
Summary: Extra tools for %name
Group: System/Servers

%description tools
This package contains the extra tools for %name

%package backend-mysql
Summary: MySQL backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: libmysqlclient-devel
%global backends %backends gmysql

%description backend-mysql
This package contains the gmysql backend for %name

%package backend-postgresql
Summary: PostgreSQL backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: postgresql-devel
%global backends %backends gpgsql

%description backend-postgresql
This package contains the gpgsql backend for %name

%package backend-pipe
Summary: Pipe backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends pipe

%description backend-pipe
This package contains the pipe backend for %name

%package backend-remote
Summary: Remote backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends remote

%description backend-remote
This package contains the remote backend for %name

%package backend-ldap
Summary: LDAP backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: libldap-devel
%global backends %backends ldap

%description backend-ldap
This package contains the ldap backend for %name

%package backend-lua2
Summary: LUA2 backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends lua2

%description backend-lua2
This package contains the lua2 backend for %name

%package backend-sqlite
Summary: SQLite backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends gsqlite3

%description backend-sqlite
This package contains the SQLite backend for %name

%package backend-geoip
Summary: GeoIP backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: libmaxminddb-devel
BuildRequires: libyaml-cpp-devel
%global backends %backends geoip

%description backend-geoip
This package contains the GeoIP backend for %name

%package backend-tinydns
Summary: TinyDNS backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: tinycdb-devel
%global backends %backends tinydns

%description backend-tinydns
This package contains the TinyDNS backend for %name

%package ixfrdist
Summary: A program to redistribute zones over AXFR and IXFR
Group: System/Servers
BuildRequires: libyaml-cpp-devel

%description ixfrdist
This package contains the ixfrdist program.


%prep
%setup
%patch4 -p1
%ifarch %e2k
sed -i 's/constexpr QClass QClass/inline &/' pdns/qtype.hh
%endif

%build
export CPPFLAGS="-DLDAP_DEPRECATED"
export BUILDER_VERSION=%version
export PDNS_TEST_NO_IPV6=1

%autoreconf
%configure \
    --sysconfdir=%_sysconfdir/%name \
    --disable-static \
    --enable-fortify-source=auto \
    --enable-lto=auto \
    --disable-dependency-tracking \
    --disable-silent-rules \
    --with-modules='' \
    --with-lua \
    --enable-lua-records \
    --with-dynmodules='%backends' \
    --enable-tools \
    --with-libsodium \
    --enable-remotebackend-zeromq \
    --enable-unit-tests \
    --enable-reproducible \
    --enable-dns-over-tls \
    --enable-systemd --with-systemd=%_unitdir \
    --with-socketdir=/run \
    --enable-ixfrdist

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/%name/*.la
mv %buildroot%_sysconfdir/%name/pdns.conf{-dist,}

# rename zone2ldap to pdns-zone2ldap (rhbz#1193116)
mv %buildroot%_bindir/zone2ldap %buildroot%_bindir/pdns_zone2ldap
mv %buildroot%_man1dir/zone2ldap.1 %buildroot%_man1dir/pdns_zone2ldap.1

# change user/group to pdns
# change default backend to bind
sed -i \
    -e 's/# setuid=/setuid=pdns/' \
    -e 's/# setgid=/setgid=pdns/' \
    -e 's/# launch=/launch=bind/' \
    -e 's/# security-poll-suffix=secpoll\.powerdns\.com\./security-poll-suffix=/' \
    %buildroot%_sysconfdir/%name/pdns.conf

rm %buildroot%_bindir/stubquery

mkdir -p %buildroot%_localstatedir/%name

%check
%make_build -C pdns check || cat pdns/test-suite.log

%pre
groupadd -r -f %name
useradd -M -r -d %_localstatedir/%name -s /bin/false -c "PowerDNS user" -g %name %name >/dev/null 2>&1 ||:

%post
# Fix permissions for config on update
if [ $1 -eq 2 ]; then
    chown --quiet --from=root:root root:%name %_sysconfdir/%name/pdns.conf 
    chmod --quiet g+r %_sysconfdir/%name/pdns.conf
fi
%post_service pdns

%preun
%preun_service pdns

%files
%doc COPYING README
%_bindir/pdns_control
%_bindir/pdnsutil
%_bindir/pdns_zone2ldap
%_bindir/zone2sql
%_bindir/zone2json
%_sbindir/pdns_server
%_man1dir/pdns_control.1.*
%_man1dir/pdns_server.1.*
%_man1dir/zone2sql.1.*
%_man1dir/zone2json.1.*
%_man1dir/pdns_zone2ldap.1.*
%_man1dir/pdnsutil.1.*
%_unitdir/pdns.service
%_unitdir/pdns@.service
%_libdir/%name/libbindbackend.so
%dir %_libdir/%name
%dir %attr(-,root,%name) %_sysconfdir/%name
%dir %attr(0750, root, %name) %_localstatedir/%name
%attr(0640,root,%name) %config(noreplace) %_sysconfdir/%name/pdns.conf

%files tools
%_bindir/calidns
%_bindir/dnsbulktest
%_bindir/dnsgram
%_bindir/dnspcap2calidns
%_bindir/dnspcap2protobuf
%_bindir/dnsreplay
%_bindir/dnsscan
%_bindir/dnsscope
%_bindir/dnstcpbench
%_bindir/dnswasher
%_bindir/dumresp
%_bindir/ixplore
%_bindir/pdns_notify
%_bindir/nproxy
%_bindir/nsec3dig
%_bindir/saxfr
%_bindir/sdig
%_man1dir/calidns.1.*
%_man1dir/dnsbulktest.1.*
%_man1dir/dnsgram.1.*
%_man1dir/dnspcap2calidns.1.*
%_man1dir/dnspcap2protobuf.1.*
%_man1dir/dnsreplay.1.*
%_man1dir/dnsscan.1.*
%_man1dir/dnsscope.1.*
%_man1dir/dnstcpbench.1.*
%_man1dir/dnswasher.1.*
%_man1dir/dumresp.1.*
%_man1dir/ixplore.1.*
%_man1dir/pdns_notify.1.*
%_man1dir/nproxy.1.*
%_man1dir/nsec3dig.1.*
%_man1dir/saxfr.1.*
%_man1dir/sdig.1.*

%files backend-mysql
%_pkgdocdir/*schema.mysql.sql
%_pkgdocdir/enable-foreign-keys.mysql.sql
%_libdir/%name/libgmysqlbackend.so

%files backend-postgresql
%_pkgdocdir/*schema.pgsql.sql
%_libdir/%name/libgpgsqlbackend.so

%files backend-pipe
%_libdir/%name/libpipebackend.so

%files backend-remote
%_libdir/%name/libremotebackend.so

%files backend-ldap
%_pkgdocdir/dnsdomain2.schema
%_pkgdocdir/pdns-domaininfo.schema
%_libdir/%name/libldapbackend.so

%files backend-lua2
%_libdir/%name/liblua2backend.so

%files backend-sqlite
%_pkgdocdir/*schema.sqlite3.sql
%_libdir/%name/libgsqlite3backend.so

%files backend-geoip
%_libdir/%name/libgeoipbackend.so

%files backend-tinydns
%_libdir/%name/libtinydnsbackend.so

%files ixfrdist
%_bindir/ixfrdist
%_man1dir/ixfrdist.*
%_man5dir/ixfrdist.yml.*
%_sysconfdir/%name/ixfrdist.example.yml
%_unitdir/ixfrdist.service
%_unitdir/ixfrdist@.service

%changelog
