%def_enable check

Name: pve-common
Summary: PVE base library
Version: 8.3.1
Release: alt2
License: AGPL-3.0+
Group: Development/Perl
Url: https://git.proxmox.com/

Source: %name-%version.tar

ExclusiveArch: x86_64 aarch64

BuildRequires: perl-Encode
BuildRequires: perl-ph
BuildRequires: perl(IO/Socket/IP.pm)
BuildRequires: perl(Filesys/Df.pm)
BuildRequires: perl(URI/Escape.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(String/ShellQuote.pm)
BuildRequires: perl(IO/AtomicFile.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl(Devel/Cycle.pm)
BuildRequires: perl(Net/IP.pm)
BuildRequires: perl(Net/DBus.pm)
BuildRequires: perl(Pod/Parser.pm)
BuildRequires: perl(Clone.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(Linux/Inotify2.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(MIME/Base32.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm)
BuildRequires: perl(Crypt/OpenSSL/RSA.pm)
BuildRequires: perl(Date/Parse.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(HTTP/Daemon.pm)
BuildRequires: perl(CPAN/Meta/YAML.pm)
BuildRequires: perl(Net/LDAP.pm)
BuildRequires: perl(PVE/RS/CalendarEvent.pm)
BuildRequires: perl(AnyEvent.pm)
# alt regressive tests
BuildRequires: perl(TAP/Harness.pm)
BuildRequires: perl(Test/MockModule.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(NetAddr/IP.pm)

%description
This package contains the base library used by other PVE components.

%prep
%setup -q -n %name-%version
sed -i 's|Proxmox VE|PVE|' src/PVE/Tools.pm
# No mknod syscall in perl for aarch64:
%ifarch aarch64
sed -i 's/SYS_mknod,/SYS_mknodat,/' src/PVE/Syscall.pm
sed -i 's/SYS_mknod,/SYS_mknodat, -100,/' src/PVE/Tools.pm
%endif

%install
cd src
%make DESTDIR=%buildroot install
cd ..

%check
# upstream tests
make -C test check

%files
%doc debian/copyright
%perl_vendor_privlib/PVE

%changelog
