%define _unpackaged_files_terminate_build 1

%define oname pyFltk
%define mname pyfltk

Name: python3-module-%mname
Version: 1.3.8
Release: alt1.1

Summary: Python wrapper for the FLTK

Group: Development/Python3
License: LGPL-2.0
# https://pypi.org/project/pyFltk
Url: https://pyfltk.sourceforge.io/

# Source-url: https://master.dl.sourceforge.net/project/pyfltk/pyfltk/pyFltk-%version/pyFltk-%version.tar.gz
Source: %oname-%version.tar

# from Debian
Patch: build-with-swig-4.1.patch

BuildRequires(pre): rpm-macros-python3
BuildRequires: rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: gcc-c++
BuildRequires: libfltk-devel
BuildRequires: swig

BuildRequires: libpng-devel
BuildRequires: libjpeg-devel
BuildRequires: libXfixes-devel
BuildRequires: libXcursor-devel
BuildRequires: libXinerama-devel
BuildRequires: libX11-devel
BuildRequires: libcairo-devel
BuildRequires: libXft-devel

%description
pyFLTK: Python Wrapper for the FLTK library.

GOALS:
o To wrap FLTK in Python
o To develop a parser to read Fluid's FL files and generate
  Python code.
o To port all programs in test/ to Python using pyFLTK

%prep
%setup -n %oname-%version
%autopatch -p1

%ifarch %e2k
# unsupported as of lcc 1.25.23 (mcst#7497)
sed -i '/-Wformat=1/d' setup.py
%endif

%build
%{python3_setup:} swig
%pyproject_build

%install
%pyproject_install

# strip tests
rm -r %buildroot%python3_sitelibdir/fltk/test/
# strip intermediate devel files
rm %buildroot%python3_sitelibdir/fltk/fltk_wrap.{cpp,h}
# strip docs
rm -r %buildroot%python3_sitelibdir/fltk/docs/

%files
%doc CHANGES README.md
%python3_sitelibdir/fltk/
%python3_sitelibdir/%{pyproject_distinfo %mname}/

%changelog
