%define oname pymemcache

# FAILED pymemcache/test/test_serde.py::test_compressed_complex
%ifnarch %ix86 armh
%def_with check
%else
%def_without check
%endif

Name: python3-module-%oname
Version: 4.0.0
Release: alt1

Summary: A comprehensive, fast, pure Python memcached client

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/pymemcache

# https://github.com/pinterest/pymemcache.git
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-six

BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-mock
BuildRequires: python3-module-faker
BuildRequires: python3-module-zstd

%description
A comprehensive, fast, pure-Python memcached client.

pymemcache supports the following features:

* Complete implementation of the memcached text protocol.
* Connections using UNIX sockets, or TCP over IPv4 or IPv6.
* Configurable timeouts for socket connect and send/recv calls.
* Access to the "noreply" flag, which can significantly increase the speed of writes.
* Flexible, modular and simple approach to serialization and deserialization.
* The (optional) ability to treat network and memcached errors as cache misses.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This pakage contains tests for %oname.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
py.test-3

%files
%doc *.rst *.md *.txt
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info
%exclude %python3_sitelibdir/*/test

%files tests
%python3_sitelibdir/*/test

%changelog
