%define _unpackaged_files_terminate_build 1
%define pypi_name pytz

Name: python3-module-%pypi_name
Epoch: 1
Version: 2023.3.post1
Release: alt1

Summary: World timezone definitions, modern and historical
Source0: %pypi_name-%version.tar
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.org/project/pytz
VCS: https://github.com/stub42/pytz

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%description
pytz brings the Olson tz database into Python. This library allows accurate and
cross platform timezone calculations using Python 2.4 or higher. It also solves
the issue of ambiguous times at the end of daylight saving time, which you can
read more about in the Python Library Reference (datetime.tzinfo).

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
# sync to .github/workflows/main.yml
cat > tox.ini <<'EOF'
[testenv]
commands =
    python pytz/tests/test_lazy.py -vv
    python pytz/tests/test_tzinfo.py -vv
EOF
%tox_check_pyproject

%files
%python3_sitelibdir/pytz/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
