%define oname whitenoise

# needs tox >=4.2
%def_without check

Name: python3-module-%oname
Version: 6.6.0
Release: alt1.1

Summary: Radically simplified static file serving for Python web apps

License: MIT
Group: Development/Python3
Url: https://github.com/evansd/whitenoise

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme

%if_with check
BuildRequires: python3-module-coverage
BuildRequires: python3-module-django
BuildRequires: python3-module-brotlipy
%endif

%description
With a couple of lines of config WhiteNoise allows your web app to serve
its own static files, making it a self-contained unit that can be deployed
anywhere without relying on nginx, Amazon S3 or any other external service.
(Especially useful on Heroku, OpenShift and other PaaS providers.)

%package docs
Summary: Documentation for %name
Group: Development/Documentation

%description docs
With a couple of lines of config WhiteNoise allows your web app to serve
its own static files, making it a self-contained unit that can be deployed
anywhere without relying on nginx, Amazon S3 or any other external service.
(Especially useful on Heroku, OpenShift and other PaaS providers.)

This package contains documentation for %name

%prep
%setup

%build
%pyproject_build

export PYTHONPATH=$PWD
%make SPHINXBUILD="sphinx-build-3" -C docs man

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE *.rst
%python3_sitelibdir/*

%files docs
%doc docs/*

%changelog
