%define _unpackaged_files_terminate_build 1

# for llvm built with clang we should use lld due thinLTO bitcode
# in static libs
# otherwise use bfd/gold linker
%ifnarch x86_64 ppc64le
%def_without lld
%global optflags_lto %optflags_lto -ffat-lto-objects
%else
%def_with lld
%global optflags_lto %nil
%endif

%def_with ClangCodeModel
%define qt_version 6.2.4

%ifarch %not_qt6_qtwebengine_arches
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

%add_findreq_skiplist  %_datadir/qtcreator/*
%add_findprov_skiplist %_datadir/qtcreator/*

Name:    qt-creator
Version: 15.0.1
Release: alt1

Summary: Cross-platform IDE for Qt
License: GPL-3.0 with Qt-GPL-exception-1.0 and MIT and LGPL-2.0 and LGPL-2.1 and LGPL-3.0 and BSD-3-Clause and BSL-1.0 and ALT-Public-Domain
Group:   Development/Tools

URL: http://qt-project.org/wiki/Category:Tools::QtCreator
VCS: git://code.qt.io/qt-creator/qt-creator.git
Packager: Andrey Cherepanov <cas@altlinux.org>

ExcludeArch: %ix86 armh

Source: %name-%version.tar
Source1: submodules.tar

Patch0: %name-%version-%release.patch

Provides: qtcreator = %EVR
Obsoletes: qtcreator < %EVR
Provides: qt-creator-clangcodemodel = %EVR
Obsoletes: qt-creator-clangcodemodel < %EVR

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): qt6-base-devel >= %qt_version
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-qt6-webengine
BuildRequires: gcc-c++
BuildRequires: qt6-designer >= %qt_version
BuildRequires: qt6-declarative-devel >= %qt_version
BuildRequires: qt6-tools-devel >= %qt_version
BuildRequires: qt6-serialport-devel
%if_enabled qtwebengine
BuildRequires: qt6-webengine-devel >= %qt_version
%endif
BuildRequires: qt6-svg-devel >= %qt_version
BuildRequires: qt6-5compat-devel >= %qt_version
BuildRequires: qt6-shadertools-devel >= %qt_version
BuildRequires: qt6-quicktimeline-devel >= %qt_version
BuildRequires: kf5-syntax-highlighting-devel
%if_with ClangCodeModel
BuildRequires: clang
BuildRequires: clang-devel
BuildRequires: clang-tools
BuildRequires: clangd
%if_with lld
BuildRequires: lld /proc
%endif
BuildRequires: llvm-devel
%endif
BuildRequires: libsystemd-devel
BuildRequires: elfutils-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
BuildRequires: libxml2-devel
# Qbs documentation
#BuildRequires: python3-module-lxml
#BuildRequires: python3-module-bs4
# Missing build requirements
#BuildRequires: litehtml-devel
BuildRequires: libffi-devel
BuildRequires: xml-utils
BuildRequires: python3-module-lxml
BuildRequires: python3-module-beautifulsoup4
BuildRequires: libedit-devel
BuildRequires: terminfo

Requires: %name-core = %EVR
# Add Qt5 build environment to build Qt project
Requires: qt6-base-devel
Requires: qt6-tools

%ifarch %e2k
# error: cpio archive too big - 4446M
%global __find_debuginfo_files %nil
%endif
%ifarch loongarch64
# Similar problem here (the size is even bigger for LoongArch is a RISC).
# However we want to have readable backtraces, so do NOT disable debuginfo
# completely:
%add_optflags -g1
%endif

%add_python3_req_skip dmgbuild

%description
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This package contains IDE and Qt5 build environment.

%package core
Summary: Cross-platform IDE for Qt
Group:   Development/Tools
Requires: %name-data = %EVR
Provides: qbs = 1.14.0
Obsoletes: qbs < 1.14.0
Requires: qt6-translations

%description core
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This is core part of IDE without Qt5 build environment.

%package doc
Summary: %name docs
Group: Documentation
%if_enabled qtwebengine
Requires: %name
%endif
Requires: qt6-base-doc
Requires: qt6-tools

%description doc
Documentation for %name

%package data
Summary: Data files for %name
Group: Development/Tools
%if_enabled qtwebengine
Requires: %name-core
%endif

%description data
Data files for %name

%prep
%setup
# Unpack submodules content
tar xf %SOURCE1
#sed -i 's,tools\/qdoc3,bin,' doc/doc.pri
#subst 's,share\/doc\/qtcreator,share\/qtcreator\/doc,' doc/doc.pri src/plugins/help/helpplugin.cpp
%patch0 -p1
%ifarch %e2k
# fix ICE
sed -i 's/acceptor = acceptor/acceptor/' src/plugins/projectexplorer/projectexplorer.cpp
# error: no instance of constructor matches the argument list
sed -i '/~Payload()/i Payload() {}' src/plugins/perfprofiler/perfprofilerflamegraphmodel.cpp
%endif
# fix build qch_docs
sed -i '/LicenseFile/d' src/libs/qlitehtml/src/3rdparty/qt_attribution.json


%build
export QTDIR=%_qt6_prefix
export PATH="%{_qt6_bindir}:$PATH"
%if_with ClangCodeModel
export LLVM_INSTALL_DIR="%_prefix"
%remove_optflags -frecord-gcc-switches
%endif

%cmake -GNinja \
    -Wno-dev \
    -DWITH_DOCS=ON \
    -DBUILD_QBS=ON \
    -Djournald=ON \
    -DBUILD_DEVELOPER_DOCS=OFF \
    -DCMAKE_INSTALL_LIBDIR=%_lib \
    -DCMAKE_EXE_LINKER_FLAGS="$LDFLAGS -Wl,-rpath,%_libdir/qtcreator -Wl,-rpath,%_libdir/qtcreator/plugins" \
    -DCMAKE_SHARED_LINKER_FLAGS="$LDFLAGS %{?_with_lld:-fuse-ld=lld -Wl,--build-id=sha1} -Wl,-rpath,%_libdir/qtcreator -Wl,-rpath,%_libdir/qtcreator/plugins"

%ninja_build -C "%_cmake__builddir"
%ninja_build -C "%_cmake__builddir" qch_docs

%install
%ninja_install -C "%_cmake__builddir"
# Unable to install documentstion using ninja-build
#%%ninja_install -C "%_cmake__builddir" qch_docs
install -Dpm0644 %_cmake__builddir/share/doc/qtcreator/qtcreator.qch %buildroot%_defaultdocdir/qtcreator/qtcreator.qch

# Remove Windows cdb debugger support to prevent unmet python2.7(cdbext)
rm -f %buildroot%_datadir/qtcreator/debugger/cdbbridge.py

# Add correct pkgname to appdata.xml file
subst '/<releases>/i \ <pkgname>qt-creator</pkgname>' %buildroot%_datadir/metainfo/*.xml

%files

%files core
%doc README* LICENSE*
%_bindir/*
%_libdir/qtcreator
%_prefix/libexec/qtcreator
%_iconsdir/hicolor/*/apps/QtProject-qtcreator.png
%_desktopdir/*.desktop
%_datadir/metainfo/*.xml
%_libdir/qbs/plugins/*.so

%files doc
%_defaultdocdir/qtcreator

%files data
%dir %_datadir/qtcreator
%_datadir/qtcreator/*

%changelog
