%define srcname streamlink

Name: streamlink
Version: 6.7.3
Release: alt1

Summary: Python library for extracting streams from various websites

# src/streamlink/packages/requests_file.py is Apache-2.0
License: BSD-2-Clause AND Apache-2.0
Group: Video
Url: https://streamlink.github.io/

#Source-url: https://github.com/streamlink/streamlink/archive/refs/tags/%version.tar.gz
# Source-url: %__pypi_url %srcname
Source: %name-%version.tar

# Use pycryptodomex library instead of pycryptodome
Patch1: %name-6.2.1-pycryptodomex.patch
# Fix documentation build
Patch2: %name-6.6.2-documentation.patch

BuildArch: noarch

AutoProv: no

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-wheel python3-module-setuptools
BuildRequires: python3-module-exceptiongroup

# generated by 'epm restore --dry-run' from streamlink/dev-requirements.txt
%py3_buildrequires setuptools >= 64.0.0
#py3_buildrequires versioningit < 4
#py3_buildrequires versioningit >= 2.0.0
#py3_buildrequires pytest >= 8.0.0
#py3_buildrequires pytest-asyncio
#py3_buildrequires pytest-trio
#py3_buildrequires requests-mock
%py3_buildrequires freezegun >= 1.0.0
#py3_buildrequires pytest-cov
#py3_buildrequires coverage[toml]
%py3_buildrequires ruff >= 0.3.7
%py3_buildrequires mypy >= 1.9.0
#py3_buildrequires lxml-stubs
#py3_buildrequires trio-typing
#py3_buildrequires types-freezegun
#py3_buildrequires types-requests
#py3_buildrequires types-setuptools
#py3_buildrequires types-urllib3

# generated by 'epm restore --dry-run' from streamlink/pyproject.toml
%py3_use certifi
%py3_use exceptiongroup
%py3_use isodate
%py3_use lxml < 6
%py3_use lxml >= 4.6.4
%py3_use pycountry
%py3_use pycryptodome < 4
%py3_use pycryptodome >= 3.4.3
%py3_use pysocks >= 1.5.6
%py3_use pysocks >= 1.5.7
%py3_use requests < 3
%py3_use requests >= 2.26.0
%py3_use trio < 1
%py3_use trio >= 0.22.0
%py3_use trio-websocket < 1
%py3_use trio-websocket >= 0.9.0
%py3_use typing-extensions >= 4.0.0
%py3_use urllib3 < 3
%py3_use urllib3 >= 1.26.0
%py3_use websocket-client < 2
%py3_use websocket-client >= 1.2.1


# for completions
BuildRequires: python3-module-shtab

# Recommends:     %_bindir/ffmpeg

%description
Streamlink is a command-line utility that pipes video streams from various
services into a video player, such as VLC. The main purpose of Streamlink is to
allow the user to avoid buggy and CPU heavy flash plugins but still be able to
enjoy various streamed content. There is also an API available for developers
who want access to the video stream data. This project was forked from
Livestreamer, which is no longer maintained.

%package bash-completion
Group: Shells
Summary: Bash completion for %srcname
Requires: %name = %version-%release
Requires: bash-completion
#Supplements:    (%name and bash-completion)

%description bash-completion
Bash command line completion support for %srcname.

%package zsh-completion
Group: Shells
Summary: Zsh completion for %srcname
Requires: %name = %version-%release
Requires: zsh
#Supplements:    (%name and zsh)

%description zsh-completion
Zsh command line completion support for %srcname.

%prep
%setup
%patch2 -p1

%build
%pyproject_build

%install
%pyproject_install

install -Dpm 0644 docs/_build/man/%srcname.1 %buildroot%_man1dir/%srcname.1

# Build and install shell completion files
PYTHONPATH=%buildroot%python3_sitelibdir ./script/build-shell-completions.sh
install -Dm644 completions/bash/%srcname %buildroot%_datadir/bash-completion/completions/%srcname
install -Dm644 completions/zsh/_%srcname %buildroot%_datadir/zsh/site-functions/_%srcname

%files
%doc README.md
%doc LICENSE
%_bindir/%srcname
%python3_sitelibdir/%name/
%python3_sitelibdir/streamlink_cli/
%python3_sitelibdir/streamlink-%version.dist-info/
%_man1dir/%srcname.1.*

%files bash-completion
%_datadir/bash-completion/completions/%srcname

%files zsh-completion
%_datadir/zsh/site-functions/_%srcname

#%files doc
#%doc docs/_build/html/
#%license LICENSE

%changelog
