Name: sway
Version: 1.9
Release: alt1
Epoch:   1
Summary: i3wm drop-in replacement for Wayland
License: MIT
Url: http://swaywm.org/
Group: Graphical desktop/Other

# https://github.com/swaywm/sway
# git://git.altlinux.org/gears/s/sway.git
Source0: %name-%version.tar
Source1: startsway
Source2: Sway_Wallpaper_Gray.png

Patch1: 0001-Change-config.patch

%define _unpackaged_files_terminate_build 1

BuildRequires: asciidoc-a2x
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libpam-devel
BuildRequires: meson
BuildRequires: pkgconfig(basu)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(libcap)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevdev)
BuildRequires: pkgconfig(libinput) >= 1.21.0
BuildRequires: pkgconfig(libpcre2-8)
BuildRequires: pkgconfig(pango)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(wlroots) >= 0.17.0
BuildRequires: pkgconfig(xcb-icccm)
BuildRequires: pkgconfig(xkbcommon) >= 1.5.0
BuildRequires: scdoc
BuildRequires: time

# swaybg is now distributed as a standalone program which is compatible with many Wayland compositors (sway 1.1-rc1)
Requires: swaybg

# swayidle, a new idle management daemon, is available separately (sway 1.0)
Requires: swayidle

Requires: foot
Requires: dmenu-wl
Requires: %name-data

%description
Sway is a drop-in replacement for the i3 window manager, but for Wayland
instead of X11. It works with your existing i3 configuration and
supports most of i3's features, and a few extras.

%package data
Summary: i3wm drop-in replacement for Wayland - data files
Group: Graphical desktop/Other
BuildArch: noarch

%description data
This package contains data files.

%prep
%setup
%autopatch -p1

%build
%meson \
	-Dwerror=false \
	-Dzsh-completions=false \
	-Dbash-completions=false \
	-Dfish-completions=false \
	#
%meson_build

%install
%meson_install

mkdir -p %buildroot/%_sysconfdir/%name/config.d

install -p -m0755 -D %SOURCE1 %buildroot/%_bindir/
install -p -m0644 -D %SOURCE2 %buildroot/%_datadir/backgrounds/%name/

%files
%doc LICENSE
%doc README.md
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/config.d
%config(noreplace) %_sysconfdir/%name/config
%_bindir/sway
%_bindir/startsway
%_bindir/swaybar
%_bindir/swaymsg
%_bindir/swaynag
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_datadir/wayland-sessions/sway.desktop

%files data
%dir %_datadir/backgrounds/%name
%_datadir/backgrounds/%name/*

%changelog
