%define _vklib amdvlk
%define _vkdir %_datadir/vulkan/icd.d
%define _vkldir %_datadir/vulkan/implicit_layer.d
# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%ifarch x86_64
%define optflags_debug -g1
%else
%define optflags_debug -g0
%endif
# As ubuntu
%define gcc_ver 9
%define llvm_ver 20.1

%define _vk_api_version 1.4.313

%def_with clang
%def_with wayland
%def_with shader_cache

%define optflags_lto %nil
%define _optlevel 3

%ifarch x86_64
%define bits 64
%endif
%ifarch %ix86
%define bits 32
%endif

Name: vulkan-amdgpu
Version: 2025.Q2.1
Release: alt2
License: MIT
Url: https://github.com/GPUOpen-Drivers/AMDVLK
Summary: AMD Open Source Driver For Vulkan
Group: System/X11

ExclusiveArch: x86_64 %ix86

Requires: vulkan-filesystem

BuildRequires(pre): rpm-macros-cmake /proc
BuildRequires: cmake ninja-build python3-devel python3-module-jinja2 curl libxcb-devel libssl-devel
BuildRequires: libX11-devel libxshmfence-devel libXrandr-devel glslang libdxcompiler-devel python3-module-ruamel-yaml
BuildRequires: rapidjson-devel libyaml-devel libzstd-devel
%if_with wayland
BuildRequires: wayland-devel libwayland-server-devel libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel
BuildRequires: libffi-devel
%endif
%if_with clang
BuildRequires: clang%{llvm_ver} mold llvm%{llvm_ver}-devel gcc-c++ libstdc++-devel-static
%else
BuildRequires: gcc%{gcc_ver}-c++ libstdc++%{gcc_ver}-devel-static
%endif

Source0: xgl.tar
Source1: pal.tar
Source2: llpc.tar
Source3: gpurt.tar
Source4: llvm.tar
Source5: metrohash.tar
Source6: amd_icd.json
Source7: cwpack.tar
Source8: VK_LAYER_AMD_switchable_graphics.json
Source9: llvm-dialects.tar

# https://github.com/Tencent/rapidjson/pull/719
Patch: pal-rapidjson-719.patch
Patch1: pal-alt-unbundle-libs.patch

%description
The AMD Open Source Driver for Vulkan(r) is an open-source Vulkan driver for
Radeon(tm) graphics adapters on Linux(r). It is built on top of AMD's Platform
Abstraction Library (PAL), a shared component that is designed to encapsulate
certain hardware and OS-specific programming details for many of AMD's 3D and
compute drivers. Leveraging PAL can help provide a consistent experience across
platforms, including support for recently released GPUs and compatibility with
AMD developer tools.

%prep
rm -rf %_builddir/*
%setup -n xgl -b0 -b1 -b2 -b3 -b4 -b5 -b7 -b9
pushd %_builddir/pal
%patch1 -p2
popd
mkdir -p %_builddir/llvm-project
mv %_builddir/llvm/llvm %_builddir/llvm-project
cp -ar %_builddir/llvm/{cmake,third-party} %_builddir/llvm-project/
# llvm-dialects hack
rm -rf %_builddir/llpc/imported/llvm-dialects && ln -s %_builddir/llvm-dialects %_builddir/llpc/imported/llvm-dialects

%build
# build amdvlk.so
# according https://github.com/GPUOpen-Drivers/AMDVLK#build-driver-and-generate-json-files
%if_with clang
export ALTWRAP_LLVM_VERSION=%llvm_ver
%cmake \
	-GNinja \
	-DXGL_USE_CLANG=ON \
	-DCMAKE_CXX_COMPILER=clang++ \
	-DCMAKE_C_COMPILER=clang \
%else	
export GCC_VERSION=%{gcc_ver} \
%cmake \
	-GNinja \
%endif
%if_with wayland
	-DBUILD_WAYLAND_SUPPORT=ON \
%endif
%if_with shader_cache
	-DLLPC_ENABLE_SHADER_CACHE=1 \
%endif
%ifarch x86_64
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
%endif
%if_with clang
	-DLLVM_USE_LINKER=mold \
	-DCMAKE_CXX_LINK_FLAGS="-fuse-ld=mold -Wl,--thinlto-jobs=all" \
%endif
        -DXGL_METROHASH_PATH=%_builddir/metrohash \
        -DXGL_CWPACK_PATH=%_builddir/cwpack \
        -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON
%cmake_build

%install
mkdir -p %buildroot{%_vkdir,%_vkldir,%_libdir,%_sysconfdir/amd}
touch %buildroot%_sysconfdir/amd/amdVulkanSettings.cfg

install -p -m644 %_builddir/xgl/%_cmake__builddir/icd/%_vklib%bits.so %buildroot%_libdir/%_vklib.so
for f in %buildroot%_vkdir/$(basename %SOURCE6) %buildroot%_vkldir/$(basename %SOURCE8); do install -pD -m644 /dev/null "$f"; done
sed -e 's|@API_VERSION@|%_vk_api_version|g' %SOURCE6 > %buildroot%_vkdir/$(basename %SOURCE6)
sed -e 's|@API_VERSION@|%_vk_api_version|g' %SOURCE8 > %buildroot%_vkldir/$(basename %SOURCE8)

%files
%_libdir/*.so
%_vkdir/*.json
%_vkldir/*.json
%dir %_sysconfdir/amd
%ghost %attr(644,root,root) %config(missingok) %_sysconfdir/amd/*.cfg

%changelog
