%def_enable introspection
%def_enable vala
%def_disable docs

%define gtk3_soname 4

Name: xfce4-panel
Version: 4.20.5
Release: alt1

Summary: Panel for Xfce
Summary(ru_RU.UTF-8): Панель для окружения рабочего стола Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/xfce4-panel/start

Vcs: https://gitlab.xfce.org/xfce/xfce4-panel.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

%define xfce_min_vers 4.18.0

BuildRequires: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= %xfce_min_vers
BuildRequires: libxfce4ui-gtk3-devel >= %xfce_min_vers libexo-gtk3-devel >= %xfce_min_vers libgarcon-gtk3-devel >= %xfce_min_vers
Buildrequires: libxfce4windowing-devel >= 4.20.1-alt1
BuildRequires: libX11-devel libXext-devel libwnck3-devel
BuildRequires: libgtk+3-devel
BuildRequires: libwayland-client-devel libgtk-layer-shell-devel
BuildRequires: libdbusmenu-gtk3-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxfce4util-gir-devel >= 4.15.6-alt1}
%{?_enable_vala:BuildRequires: vala-tools libxfce4util-vala >= %xfce_min_vers}
# NOTE: gtk-doc is required by build system even if docs are disabled.
BuildRequires: gtk-doc

Requires: xfce4-common

Obsoletes: xfce4-showdesktop-plugin, xfce4-windowlist-plugin

# libxfce4windowing >= 4.19.6 breaks API/ABI whithout soname change
Conflicts: libxfce4windowing < 4.19.6

%define libxfce4panel_name_gtk3 libxfce4panel-2.0
%define wrapper_name_gtk3 wrapper-2.0

%define _unpackaged_files_terminate_build 1

%description
%name is the panel for the Xfce desktop environment.

%description -l ru_RU.UTF-8
Данный пакет содержит в себе панель для окружения рабочего стола Xfce.

%if_enabled docs
%package -n libxfce4panel-devel-doc
Summary: Documentation files to build Xfce panel plugins
Group: Development/Documentation
Provides: %name-devel-doc = %version-%release
Obsoletes: %name-devel-doc < 4.8.0
Conflicts: libxfce4panel-gtk3-devel < %version-%release
BuildArch: noarch

%description -n libxfce4panel-devel-doc
This package contains files to develop plugins for Xfce panel.
%endif

%package -n libxfce4panel-gtk3
Summary: Library for Xfce panel (GTK+3)
License: LGPLv2.1+
Group: Development/C

%description -n libxfce4panel-gtk3
This package contains library for Xfce panel plugins
(GTK+3 variant).

%package -n libxfce4panel-gtk3-devel
Summary: Development files to build Xfce panel plugins (GTK+3)
License: LGPLv2.1+
Group: Development/C
Requires: libxfce4panel-gtk3 = %version-%release

%description -n libxfce4panel-gtk3-devel
This package contains files to develop plugins for Xfce panel
(GTK+3 variant).

%if_enabled introspection
%package -n libxfce4panel-gtk3-gir
Summary: GObject introspection data for libxfce4panel-gtk3
Group: System/Libraries
Requires: libxfce4panel-gtk3 = %EVR

%description -n libxfce4panel-gtk3-gir
GObject introspection data for libxfce4panel-gtk3.

%package -n libxfce4panel-gtk3-gir-devel
Summary: GObject introspection devel data for libxfce4panel-gtk3
Group: System/Libraries
BuildArch: noarch
Requires: libxfce4panel-gtk3-gir = %EVR
Requires: libxfce4panel-gtk3-devel = %EVR

%description -n libxfce4panel-gtk3-gir-devel
GObject introspection devel data for libxfce4panel-gtk3.
%endif

%if_enabled vala
%package -n libxfce4panel-gtk3-vala
Summary: Vala bindings for libxfce4panel-gtk3
Group: System/Libraries
Requires: libxfce4panel-gtk3-devel = %EVR
BuildArch: noarch

%description -n libxfce4panel-gtk3-vala
Vala bindings for libxfce4panel-gtk3.
%endif


%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-x11 \
	--enable-wayland \
	%{subst_enable introspection} \
	%{subst_enable vala} \
%if_enabled docs
	--enable-gtk-doc \
%else
	--disable-gtk-doc \
%endif
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README.md
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%_bindir/*
%_libdir/xfce4/panel/
%exclude %_libdir/xfce4/panel/%wrapper_name_gtk3
%_iconsdir/hicolor/*/apps/*
%_datadir/xfce4/panel/
%_desktopdir/*.desktop
%exclude %_libdir/xfce4/panel/plugins/*.la

%if_enabled docs
%files -n libxfce4panel-devel-doc
%doc %_datadir/gtk-doc/html/libxfce4panel-*/
%endif

%files -n libxfce4panel-gtk3
%_libdir/%libxfce4panel_name_gtk3.so.%gtk3_soname
%_libdir/%libxfce4panel_name_gtk3.so.%gtk3_soname.*
%_libdir/xfce4/panel/%wrapper_name_gtk3

%files -n libxfce4panel-gtk3-devel
%_libdir/pkgconfig/%libxfce4panel_name_gtk3.pc
%_libdir/%libxfce4panel_name_gtk3.so
%_includedir/xfce4/%libxfce4panel_name_gtk3/

%if_enabled introspection
%files -n libxfce4panel-gtk3-gir
%_libdir/girepository-1.0/*.typelib

%files -n libxfce4panel-gtk3-gir-devel
%_datadir/gir-1.0/*.gir
%endif

%if_enabled vala
%files -n libxfce4panel-gtk3-vala
%_datadir/vala/vapi/libxfce4panel-*
%endif

%changelog
