Name: 	 c-icap
Version: 0.5.10
Release: alt1
Epoch:	 1
Packager: Andrey Cherepanov <cas@altlinux.org>

Summary: ICAP server
License: LGPL-2.1-or-later
Group: 	 System/Servers
Url: 	 https://github.com/c-icap

Source0: %name-%version.tar.gz
Source1: %name.init
Source2: %name.watch
Source3: %name.conf
Source4: %name.service
Source5: %name.sysconfig

Requires(pre): shadow-utils

BuildRequires: doxygen libdb4-devel libldap-devel libmemcached-devel zlib-devel bzlib-devel

%description
Implementation of an Internet Content Adaptation Protocol (ICAP) server.

%package devel
Summary: ICAP development files
Group: Development/C
Requires: %name = %EVR

%description devel
Headers and libraries for an Internet Content Adaptation Protocol (ICAP)
server implementation.

%if_with clamav
%package clamav
Summary: ICAP ClamAV module
Group: System/Servers
Requires: %name = %EVR

%description clamav
ICAP module for scanning content with ClamAV.
%endif

%prep
%setup -q

sed -i "s|/var/run/c-icap|/run/c-icap|g" cfg_param.c
sed -i "s|/var/run/c-icap|/run/c-icap|g" c-icap.conf.in
sed -i "s|/var/run/c-icap|/run/c-icap|g" docs/man/c-icap.8.in
sed -i "s|/var/run/c-icap|/run/c-icap|g" docs/man/Makefile.am
sed -i "s|/var/run/c-icap|/run/c-icap|g" utils/Makefile.am
sed -i "s|/var/run/c-icap|/run/c-icap|g" Makefile.am

%build
%autoreconf
%undefine _configure_gettext
%configure --localstatedir=%_var
%make_build

%install
%makeinstall_std

install -pD -m755 %SOURCE1 %buildroot%_initdir/%name

install -pD -m644 %SOURCE4 %buildroot%_unitdir/%name.service
install -pD -m644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p %buildroot%_sbindir
mv %buildroot%_bindir/%name %buildroot%_sbindir/%name

mkdir -p %buildroot%_logdir/%name
touch %buildroot%_logdir/%name/{server,access}.log

mkdir -p %buildroot/%_cachedir/%name

rm -f %buildroot%_libdir/c_icap/*.la

# Fix configuration
. shell-config
%define cfg_set shell_config_set %buildroot%_sysconfdir/%name.conf
#cfg_set PidFile        /run/%name/%name.pid ' ' ' '
#cfg_set CommandsSocket /run/%name/%name.ctl ' ' ' '
%cfg_set ModulesDir     %_libdir/c_icap ' ' ' '
%cfg_set ServicesDir    %_libdir/c_icap ' ' ' '
%cfg_set ServerLog      %_logdir/%name/server.log ' ' ' '
%cfg_set AccessLog      %_logdir/%name/access.log ' ' ' '
%cfg_set LoadMagicFile  %_sysconfdir/%name.magic ' ' ' '

# Install /run rules
install -Dm 0644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf

chmod -x %buildroot/%_sysconfdir/%name.conf*
chmod -x %buildroot/%_sysconfdir/%name.magic*

%pre
/usr/sbin/groupadd -r -f _c_icap ||:
/usr/sbin/useradd -M -n _c_icap -r -d %_runtimedir/%name -s /dev/null -c "System user for %name" -g _c_icap > /dev/null 2>&1 ||:

# home directory was in /var/run/ before 1:0.5.6-alt2
/usr/sbin/usermod --home /run/%name _c_icap ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS README TODO contrib/get_file.pl
%config(noreplace) %_sysconfdir/%name.conf*
%config(noreplace) %_sysconfdir/%name.magic*
%config(noreplace) %_sysconfdir/sysconfig/%name
%attr(755,root,root) %_initdir/%name
%_unitdir/%name.service
%_bindir/*
%attr(755,root,root) %_sbindir/%name
%dir %_libdir/c_icap/
%_libdir/c_icap/*.so
%_libdir/libicapapi.so.*
%if_with clamav
%exclude %_libdir/c_icap/srv_clamav.so
%endif
%attr(750,_c_icap,root) %dir %_logdir/%name/
%ghost %_logdir/%name/*.log
%attr(750,_c_icap,root) %_cachedir/%name/
%_tmpfilesdir/%name.conf
%_man8dir/c-icap*.8*

%files devel
%_includedir/c_icap
%_libdir/libicapapi.so

%changelog
