# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-generic-compat
BuildRequires: /usr/bin/blender gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name cal3d
%define major 12
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

Summary:	A skeletal based character animation library
Name:		cal3d
Version:	0.11.0
Release:	alt5_22
Group:		System/Libraries
License:	LGPLv2+
URL:		http://gna.org/projects/cal3d/
Source0:	http://download.gna.org/cal3d/sources/%{name}-%{version}.tar.bz2
Patch0:		cal3d-0.11.0-gcc43.patch
Patch1:		cal3d-0.11.0-gcc7.patch
ExclusiveArch:	x86_64 aarch64 ppc64le %e2k
%ifarch x86_64 aarch64 ppc64le
BuildRequires:  valgrind
%endif
BuildRequires:	doxygen
BuildRequires:	docbook-utils
Source44: import.info

%description
Cal3D is a skeletal based character animation library. It is platform-
independent and not bound to a specific graphic API. Originally designed to
be used in a 3d client for the Worldforge project (www.worldforge.org)
it evolved into a stand-alone product that can be used in many different
projects.

%package -n %{libname}
Summary:	A skeletal based character animation library
Group:		System/Libraries
Provides:	%{name} = %{version}-%{release}

%description -n	%{libname}
Cal3D is a skeletal based character animation library. It is platform-
independent and not bound to a specific graphic API. Originally designed to
be used in a 3d client for the Worldforge project (www.worldforge.org)
it evolved into a stand-alone product that can be used in many different
projects.

%package -n %{develname}
Summary:	Headers for developing programs that will use Cal3D
Group:		Development/C++
Requires:	%{libname} = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Obsoletes:	lib%{name}12-devel

%description -n	%{develname}
This package contains the headers that programmers will need to develop
applications which will use Cal3D.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
autoreconf -fi
%configure
%make_build

%install
%makeinstall_std

%files -n %{libname}
%{_libdir}/*.so.%{major}
%{_libdir}/*.so.%{major}.*

%files -n %{develname}
%dir %{_includedir}/%{name}
%{_includedir}/%{name}/*.h
%{_libdir}/*.so
%{_libdir}/pkgconfig/%{name}.pc
%{_bindir}/%{name}_converter
%{_mandir}/man1/%{name}_converter.1*




%changelog
