%def_with libidn2
%def_with dbus
%def_with conntrack
%def_with nftset

Name: dnsmasq
Version: 2.91

Release: alt1
Summary: A lightweight caching nameserver
License: GPLv2+
Group: System/Servers
Url: https://thekelleys.org.uk/dnsmasq/
Vcs: git://thekelleys.org.uk/dnsmasq.git
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Source3: %name-helper
Source4: %name.service
Source5: %name@.service
Source6: dbus.conf
Patch: %name-%version-%release.patch

BuildRequires: glibc-kernheaders

# IDN
%if_with libidn2
BuildRequires: libidn2-devel
%else
BuildRequires: libidn-devel
%endif

# DNSSEC
BuildRequires: libnettle-devel libgmp-devel

# DBUS
%{?_with_dbus:BuildRequires: libdbus-devel}

# CONNTRACK
%{?_with_conntrack:BuildRequires: pkgconfig(libnetfilter_conntrack)}

# NFTSET
%{?_with_nftset:BuildRequires: pkgconfig(libnftables)}

%define sysconfig_file %_sysconfdir/sysconfig/%name
%define _unpackaged_files_terminate_build 1

Summary(ru_RU.UTF-8): Компактный сервер DNS и DHCP для локальных сетей

%description
Dnsmasq is lightweight, easy to configure DNS forwarder and DHCP server. It
is designed to provide DNS and, optionally, DHCP, to a small network. It can
serve the names of local machines which are not in the global DNS. The DHCP
server integrates with the DNS server and allows machines with DHCP-allocated
addresses to appear in the DNS with names configured either in each host or
in a central configuration file. Dnsmasq supports static and dynamic DHCP
leases and BOOTP for network booting of diskless machines.

%description -l ru_RU.UTF-8
Dnsmasq - это компактный, простой в настройке сервер DNS и DHCP,
разработанный для использования в небольших сетях.
По умолчанию он использует общесистемные файлы /etc/hosts и /etc/resolv.conf,
поэтому может использоваться без настройки сразу после установки.

Очень удобными функциями являются прозрачное переопределение внешних имён
через /etc/hosts и трансляция имени в наиболее подходящий клиенту IP-адрес,
если для имени определено несколько адресов из разных подсетей.

%package        utils
Summary:        Utilities for manipulating DHCP server leases
Group:          Networking/Other

%description    utils
Utilities that use the standard DHCP protocol to
query/remove a DHCP server's leases.

%prep
%setup
%patch -p1

# Setup version
sed -r -i "s;-DVERSION=.+;-DVERSION='\\\\\"%version\\\\\"';" Makefile

#enable IDN support
%if_with libidn2
sed -i 's;/\* #define HAVE_LIBIDN2 \*/;#define HAVE_LIBIDN2;' src/config.h
%else
sed -i 's;/\* #define HAVE_IDN \*/;#define HAVE_IDN;' src/config.h
%endif

#enable DNSSEC support
sed -i 's;/\* #define HAVE_DNSSEC \*/;#define HAVE_DNSSEC;' src/config.h

%if_with dbus
#enable DBUS support
sed -i 's;/\* #define HAVE_DBUS \*/;#define HAVE_DBUS;' src/config.h
%endif

%if_with conntrack
#enable CONNTRACK support
sed -i 's;/\* #define HAVE_CONNTRACK \*/;#define HAVE_CONNTRACK;' src/config.h
%endif

%if_with nftset
#enable NFTSET support
sed -i 's;/\* #define HAVE_NFTSET \*/;#define HAVE_NFTSET;' src/config.h
%endif

%build
# E2K: EDG-based compiler has many false positives
%ifnarch %e2k
%add_optflags -Werror
%endif
%make_build
%make_build -C contrib/lease-tools

%install
%makeinstall_std PREFIX=%prefix

install -d -m770 %buildroot%_sysconfdir/dnsmasq.conf.d
ln -r -s %buildroot%_sysconfdir/dnsmasq.conf.d %buildroot%_sysconfdir/dnsmasq.d
install -pD -m744 %SOURCE1            %buildroot%_initdir/%name
install -pD -m600 %SOURCE2            %buildroot%sysconfig_file
install -pD -m600 %name.conf.example  %buildroot%_sysconfdir/%name.conf
install -pD -m755 %SOURCE3            %buildroot%_sbindir/%name-helper
install -pD -m644 %SOURCE4            %buildroot%_unitdir/%name.service
install -pD -m644 %SOURCE5            %buildroot%_unitdir/%name@.service

# For utils package
install -pD -m 755 contrib/lease-tools/dhcp_release %buildroot%_bindir/dhcp_release
install -pD -m 644 contrib/lease-tools/dhcp_release.1 %buildroot%_man1dir/dhcp_release.1
install -pD -m 755 contrib/lease-tools/dhcp_lease_time %buildroot%_bindir/dhcp_lease_time
install -pD -m 644 contrib/lease-tools/dhcp_lease_time.1 %buildroot%_man1dir/dhcp_lease_time.1

# For DNSSEC support
install -pD -m 644 trust-anchors.conf %buildroot%_datadir/%name/trust-anchors.conf

%if_with dbus
# Install DBus conf file
install -pD -m 644 %SOURCE6 %buildroot%_datadir/dbus-1/system.d/dnsmasq.conf
%endif


%pre
# Create dnsmasq user
groupadd -r -f _dnsmasq ||:
useradd -r -g _dnsmasq -d /dev/null -s /dev/null -N _dnsmasq >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc CHANGELOG FAQ doc.html setup.html CHANGELOG.archive
%config(noreplace) %_sysconfdir/%name.conf
%dir %_datadir/%name/
%config(noreplace) %_datadir/%name/trust-anchors.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%if_with dbus
%config %_datadir/dbus-1/system.d/dnsmasq.conf
%endif
%dir %_sysconfdir/dnsmasq.conf.d
%_sysconfdir/dnsmasq.d
%_unitdir/%name.service
%_unitdir/%name@.service
%_initdir/%name
%_sbindir/%{name}*
%_man8dir/%{name}*
%doc contrib/dnslist contrib/dynamic-dnsmasq

%files utils
%_bindir/dhcp_*
%_man1dir/dhcp_*

%changelog
