%def_without unittests
%def_disable pywrap
%def_disable openssl

%filter_from_requires /\/sbin\/unix_chkpwd/d

Name: ecryptfs-utils
Version: 111
Release: alt1

Summary: The eCryptfs mount helper and support libraries

License: GPLv2+
Group: File tools
Url: https://launchpad.net/ecryptfs

# Source0-url: http://launchpad.net/ecryptfs/trunk/%version/+download/%{name}_%version.orig.tar.gz
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar
Source1: ecryptfs-mount-private.png

### upstream patches
# rhbz#1384023, openssl 1.1.x
Patch1: https://code.launchpad.net/~jelle-vdwaa/ecryptfs/ecryptfs/+merge/319746/+preview-diff/792383/+files/preview.diff#/%name-openssl11.patch

### downstream patches
# rhbz#500829, do not use ubuntu/debian only service
Patch92: %name-75-nocryptdisks.patch

# rhbz#553629, fix usage of salt together with file_passwd
Patch93: %name-83-fixsalt.patch

# fedora/rhel specific, rhbz#486139, remove nss dependency from umount.ecryptfs
Patch94: %name-83-splitnss.patch

# rhbz#664474, fix unsigned < 0 test
Patch95: %name-84-fixsigness.patch

# fix man pages
Patch98: %name-86-manpage.patch

# autoload ecryptfs module in ecryptfs-setup-private when needed, rhbz#707608
Patch99: %name-87-autoload.patch

# fedora/rhel specific, check for pam ecryptfs module before home migration
Patch911: %name-87-authconfig.patch

# using return after fork() in pam module has some nasty side effects, rhbz#722445
Patch914: %name-87-fixpamfork.patch

# we need gid==ecryptfs in pam module before mount.ecryptfs_private execution
Patch915: %name-87-fixexecgid.patch

# do not use zombie process, it causes lock ups at least for ssh login
Patch916: %name-87-nozombies.patch

# if we do not use zombies, we have to store passphrase in pam_data and init keyring later
Patch917: %name-87-pamdata.patch

# patch17 needs propper const on some places
Patch918: %name-87-fixconst.patch

Patch919: %name-87-syslog.patch

# if e-m-p fails, check if user is member of ecryptfs group
Patch921: %name-96-groupcheck.patch
Patch922: %name-99-selinux.patch

# rhbz#868330
Patch923: %name-100-sudokeyring.patch

# for e-u < 112
Patch924: %name-111-cve_2016_5224.patch

# do not crash if no password is available #1339714
Patch925: %name-111-nopasswd.patch

# Authconfig should no longer be used since F28
Patch926: %name-111-authselect.patch

### patches for general cleanup, should be kept and executed after all others
# allow building with -Werror
Patch999: %name-75-werror.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: swig >= 1.3.31
BuildRequires: libgcrypt-devel libkeyutils-devel libssl-devel libpam0-devel
BuildRequires: libtrousers-devel nss-devel desktop-file-utils intltool
BuildRequires: libpkcs11-helper-devel
BuildRequires: automake autoconf libtool glib2-devel gettext-devel perl-podlators libattr-devel

Requires: keyutils cryptsetup util-linux gettext-tools

%description
eCryptfs is a stacked cryptographic filesystem that ships in Linux
kernel versions 2.6.19 and above. This package provides the mount
helper and supporting libraries to perform key management and mount
functions.

Install %name if you would like to mount eCryptfs.

%package -n libecryptfs
Summary: The eCryptfs userspace library
Group: Development/C

%description -n libecryptfs
Library for eCryptfs.

%package -n libecryptfs-devel
Summary: The eCryptfs userspace development package
Group: Development/C
Requires: libecryptfs = %EVR
Requires: libkeyutils-devel
Requires: pkg-config

%description -n libecryptfs-devel
Userspace development files for eCryptfs.

%package -n python3-module-ecryptfs
Summary: Python bindings for the eCryptfs utils
Group: Development/Python
Requires: %name = %EVR
BuildRequires: make

%description -n python3-module-ecryptfs

The package contains a module that permits
applications written in the Python programming language to use
the interface supplied by the %name library.

%prep
%setup

%patch1 -p0 -b .openssl11

%patch92 -p1 -b .nocryptdisks
%patch93 -p1 -b .fixsalt
%patch94 -p1 -b .splitnss
%patch95 -p1 -b .fixsigness
%patch98 -p1 -b .manfix
%patch99 -p1 -b .autoload
%patch911 -p1 -b .authconfig
%patch914 -p1 -b .fixpamfork
%patch915 -p1 -b .fixexecgid
%patch916 -p1 -b .nozombies
%patch917 -p1 -b .pamdata
%patch918 -p1 -b .fixconst
%patch919 -p1 -b .syslog
%patch921 -p1 -b .groupcheck
%patch922 -p1 -b .selinux
%patch923 -p1 -b .sudokeyring
%patch924 -p1 -b .cve_2016_5224
%patch925 -p1 -b .nopasswd
%patch926 -p1 -b .authselect

%patch999 -p1 -b .werror

%__subst 's|/etc/init.d/cryptdisks restart|service cryptdisks restart|' src/utils/ecryptfs-setup-swap
%__subst 's|/sbin/\(u*mount\)|%_sbin/\1|g' src/utils/*

sed -i -r 's:^_syslog\(LOG:ecryptfs_\0:' src/pam_ecryptfs/pam_ecryptfs.c

# snprintf directive output may be truncated
sed -i -r 's:(snprintf.*"\%)(s/\%)(s"):\1.42\2.23\3:' \
 tests/kernel/inotify/test.c

# fix usr-move
sed -i -r 's:(rootsbindir=).*:\1"%_sbindir":' configure.ac
autoreconf -fiv

%build
%if_enabled pywrap
export PYTHON_VERSION=3
export PYTHON=%__python3
export PY3FLAGS='%(pkg-config --cflags python3)'
export CFLAGS="%optflags $PY3FLAGS"
%endif
%configure  \
    %{subst_enable pywrap} \
    %{subst_enable openssl} \
    --enable-tspi --enable-nss \
    --enable-pkcs11-helper --disable-tests \
    --with-pamdir=%_libdir/security
%make_build

%install
%makeinstall_std

find %buildroot/ -name '*.la' -print -delete
rm -rf %buildroot%_docdir/%name

#install files Makefile forgot to install
install -p -m644 %SOURCE1 %buildroot%_datadir/%name/ecryptfs-mount-private.png
for i in %buildroot%_datadir/%name/{ecryptfs-mount-private.desktop,ecryptfs-setup-private.desktop} ; do
 printf "Encoding=UTF-8\n" >> $i
 printf "Icon=%_datadir/%name/ecryptfs-mount-private.png\n" >> $i
 %__subst 's|^_||' $i
 chmod +x $i
done
for file in $(find src/desktop -name ¸*.desktop) ; do
 touch -r $file %buildroot%_datadir/%name/$(basename $file)
done
rm -f %buildroot%_datadir/%name/ecryptfs-record-passphrase

#we need ecryptfs kernel module
mkdir -p %buildroot/lib/modules-load.d/
echo -e "# ecryptfs module is needed before ecryptfs mount, so mount helper can \n# check for file name encryption support\necryptfs" \
 >%buildroot/lib/modules-load.d/ecryptfs.conf

%find_lang %name

%check
desktop-file-validate %buildroot%_datadir/%name/*.desktop

if ldd %buildroot%_sbindir/umount.ecryptfs | grep -q '%prefix/'
then
  exit 1
fi

%if_with unittests
for folder in $(find . -name py\* -type d) ; do
 export LD_LIBRARY_PATH=${folder}/src/libecryptfs/.libs
 make check -C $folder
done
%endif

%pre
groupadd -r -f ecryptfs

%post
if [ $1 -eq 1 ] ; then
 # Initial installation
 # TODO
 true
 #authselect enable-feature with-ecryptfs >/dev/null 2>&1
fi

%postun
if [ $1 -eq 0 ] ; then
 # Package removal, not upgrade
 # TODO
 true
 #authselect disable-feature with-ecryptfs >/dev/null 2>&1
fi

%files -f %name.lang
%doc COPYING
%doc README AUTHORS NEWS THANKS
%doc doc/ecryptfs-faq.html
%doc doc/ecryptfs-pkcs11-helper-doc.txt
%_sbindir/mount.ecryptfs
%_sbindir/umount.ecryptfs
%attr(4710,root,ecryptfs) %_sbindir/mount.ecryptfs_private
%_sbindir/umount.ecryptfs_private
%_bindir/ecryptfs-add-passphrase
%_bindir/ecryptfs-find
%_bindir/ecryptfs-generate-tpm-key
%_bindir/ecryptfs-insert-wrapped-passphrase-into-keyring
%_bindir/ecryptfs-manager
%_bindir/ecryptfs-migrate-home
%_bindir/ecryptfs-mount-private
%_bindir/ecryptfs-recover-private
%_bindir/ecryptfs-rewrap-passphrase
%_bindir/ecryptfs-rewrite-file
%_bindir/ecryptfs-setup-private
%_bindir/ecryptfs-setup-swap
%_bindir/ecryptfs-stat
%_bindir/ecryptfs-umount-private
%_bindir/ecryptfs-unwrap-passphrase
%_bindir/ecryptfs-verify
%_bindir/ecryptfs-wrap-passphrase
%_bindir/ecryptfsd
%_libdir/ecryptfs/
%_libdir/security/pam_ecryptfs.so
/lib/modules-load.d/ecryptfs.conf
%dir %_datadir/%name
%_datadir/%name/ecryptfs-mount-private.txt
%_datadir/%name/ecryptfs-mount-private.desktop
%_datadir/%name/ecryptfs-mount-private.png
%_datadir/%name/ecryptfs-setup-private.desktop
%_man1dir/ecryptfs-add-passphrase.1.*
%_man1dir/ecryptfs-find.1*
%_man1dir/ecryptfs-generate-tpm-key.1.*
%_man1dir/ecryptfs-insert-wrapped-passphrase-into-keyring.1.*
%_man1dir/ecryptfs-mount-private.1.*
%_man1dir/ecryptfs-recover-private.1.*
%_man1dir/ecryptfs-rewrap-passphrase.1.*
%_man1dir/ecryptfs-rewrite-file.1.*
%_man1dir/ecryptfs-setup-private.1.*
%_man1dir/ecryptfs-setup-swap.1.*
%_man1dir/ecryptfs-stat.1.*
%_man1dir/ecryptfs-umount-private.1.*
%_man1dir/ecryptfs-unwrap-passphrase.1.*
%_man1dir/ecryptfs-verify.1*
%_man1dir/ecryptfs-wrap-passphrase.1.*
%_man1dir/mount.ecryptfs_private.1.*
%_man1dir/umount.ecryptfs_private.1.*
%_man7dir/ecryptfs.7.*
%_man8dir/ecryptfs-manager.8.*
%_man8dir/ecryptfs-migrate-home.8*
%_man8dir/ecryptfsd.8.*
%_man8dir/mount.ecryptfs.8.*
%_man8dir/pam_ecryptfs.8.*
%_man8dir/umount.ecryptfs.8.*

%files -n libecryptfs
%_libdir/libecryptfs.so.*

%files -n libecryptfs-devel
%_libdir/libecryptfs.so
%_pkgconfigdir/libecryptfs.pc
%_includedir/ecryptfs.h

%if_enabled pywrap
%files -n python3-module-ecryptfs
%python3_sitelibdir/%name/
#python3_sitearch/%name/
%endif

%changelog
