%def_enable Werror
Name: fossil
Version: 2.26
Release: alt1

Summary: A distributed SCM with bug tracking and wiki
License: %bsdstyle
Group: Development/Other

Url: http://www.fossil-scm.org/
# repacked https://www.fossil-scm.org/home/tarball/version-%%version/fossil-src-%%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-licenses
BuildRequires: zlib-devel libssl-devel libreadline-devel tcl
BuildRequires: libsqlite3-devel >= 3.15.0

Requires: tcllib

%define _unpackaged_files_terminate_build 1

%description
Fossil is a simple, high-reliability, distributed software configuration
management with distributed bug tracking, distributed wiki and built-in
web interface.

%package doc
Summary: Fossil documentation
Group: Development/Documentation

%description doc
Documentation in HTML format for Fossil.

%prep
%setup
cp -at autosetup -- /usr/share/gnu-config/config.{guess,sub}

%build
# configure script is not generated by autoconf but by autosetup,
# so don't use %%configure macro
./configure \
	--prefix=%_usr \
%if "%(rpmquery --qf '%%{VERSION}' libsqlite3-devel)" >= "3.49.0"
	--disable-internal-sqlite \
%endif
	--with-openssl=auto
export CFLAGS='%optflags'
%make_build

%install
%makeinstall_std
install -pDm644 fossil.1 %buildroot%_man1dir/fossil.1

%files
%doc COPYRIGHT-BSD2.txt
%_bindir/fossil
%_man1dir/%name.1.*

# Don't package documentation,
# seems like something wrong with it.
#files doc
#doc www

%changelog
