%set_verify_elf_method unresolved=strict

Name: gnustep-back    
Version: 0.30.0
Release: alt1
Summary: The GNUstep back-end library
License: LGPL-2.1+ and GPL-3.0+
Group: Graphical desktop/GNUstep
URL: http://www.gnustep.org

# https://github.com/gnustep/libs-back
Source: libs-back-%version.tar
Patch1: gnustep-back-DejaVu-compatible-font.patch

BuildRequires: libfreetype-devel libX11-devel libXt-devel libXext-devel
BuildRequires: libXmu-devel libICE-devel libXft-devel libGL-devel
BuildRequires: libart_lgpl-devel libglitz-devel libcairo-devel
BuildRequires: gnustep-make-devel gnustep-base-devel
BuildRequires: gnustep-gui-devel = %version
BuildRequires: libXcursor-devel libXfixes-devel
BuildRequires: fonts-type1-urw gnustep-gui-doc
BuildRequires: texinfo /proc
BuildRequires: libgmp-devel libgnutls-devel libgcrypt-devel
BuildRequires: libxslt-devel libffi-devel libicu-devel

Requires: gnustep-base
Requires: gnustep-gui = %version
Requires: fonts-ttf-core

%description 
This is a back-end for the GNUstep GUI library which allows you to use
the GNUstep GUI library on an X Windows System (other back-ends will
be added later to allow you to use the GNUstep GUI Library in other
windowing environments). This package includes development headers too.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: gnustep-gui-doc

%description doc
This is develompent documentation for %name.

%prep
%setup -n libs-back-%version
%patch1 -p1

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-glitz \
	--enable-server=x11 \
	--enable-graphics=xlib \
	--with-tiff-library \
	--with-x \
	--with-installation-domain=SYSTEM

%ifarch x86_64
sed -i 's|i586|x86_64|g' $(find ./ -type f)
%endif
%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes

%make_build -C Documentation \
	messages=yes

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

%makeinstall_std -C Documentation \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

rm -rf %buildroot%_libdir/GNUstep/Documentation/Developer/Back/ReleaseNotes

install -d %buildroot%_sysconfdir/profile.d
echo "export GNUSTEP_STRING_ENCODING=UTF-8" \
	> %buildroot%_sysconfdir/profile.d/%name.sh
chmod +x %buildroot%_sysconfdir/profile.d/%name.sh

gzip ChangeLog

%files
%doc ANNOUNCE ChangeLog* COPYING* NEWS README
%_sysconfdir/profile.d/*
%_bindir/*
%_libdir/GNUstep
%_man1dir/*

%files doc
%_docdir/GNUstep

%changelog
