%def_disable snapshot

%define ver_major 45
%define beta %nil
%define api_ver 2
%define _name GPaste
%define xdg_name org.gnome.GPaste
%define _libexecdir %_prefix/libexec

%def_disable applet

Name: gpaste
Version: %ver_major.3
Release: alt1%beta

Summary: GPaste is a clipboard management system
Group: Text tools
License: BSD-2-Clause
Url: https://github.com/Keruspe/GPaste

Vcs: https://github.com/Keruspe/GPaste.git

%if_disabled snapshot
Source: %url/archive/v%version%beta/%_name-%version%beta.tar.gz
%else
Source: %_name-%version%beta.tar
%endif
Patch1: %name-42.0-alt-format.patch

Requires: lib%name = %EVR

%define glib_ver 2.70
%define gtk3_ver 3.24.0
%define gtk4_ver 4.6.0
%define adwaita_ver 1.1
%define gi_ver 1.58.0
%define vala_ver 0.42
%define mutter_ver 45.0
%define gjs_ver 1.78
%define gcr_ver 3.90.0

BuildRequires(pre):rpm-macros-meson rpm-build-gir rpm-build-vala rpm-build-systemd
BuildRequires: meson /usr/bin/appstreamcli desktop-file-utils
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libdbus-devel
BuildRequires: libgtk+3-devel >= %gtk3_ver
BuildRequires: libgtk4-devel >= %gtk4_ver pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libgjs-devel >= %gjs_ver libmutter-devel >= %mutter_ver
BuildRequires: gnome-control-center-devel
BuildRequires: gobject-introspection-devel >= %gi_ver libgtk+3-gir-devel
BuildRequires: libgtk4-gir-devel libadwaita-gir-devel
BuildRequires: vala-tools >= %vala_ver
BuildRequires: gcr4-libs-devel >= %gcr_ver

%description
This package provides gpaste-daemon is a clipboard management daemon with DBus
interface.

%package -n lib%name
Summary: GPaste library
Group: System/Libraries

%description -n lib%name
GPaste is a clipboard management system.
This package provides shared library required for GPaste components to
work.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
The lib%name-devel package contains library and header files for developing
applications that use %name.

%package -n lib%name-gir
Summary: GObject introspection data for the GPaste
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the GPaste library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GPaste
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the GPaste library.

%package -n gnome-shell-extension-%name
Summary: GNOME Shell extension for GPaste
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: gnome-shell >= %ver_major
Requires: %name = %EVR
Requires: lib%name-gir = %EVR

%description -n gnome-shell-extension-%name
GNOME Shell extension for GPaste clipboard management system.

%package applet
Summary: Tray applet to manage GPaste
Group: Graphical desktop/Other
Requires: %name = %EVR

%description applet
This package provides GPaste applet which starts the status icon
in notification area.

%prep
%setup -n %_name-%version%beta
%ifarch %ix86 armh
%patch1 -b .format
%endif

%build
%ifarch %ix86
%add_optflags -Wno-incompatible-pointer-types
%endif
%meson \
  -Dvapi=true
%nil
%meson_build

%install
%meson_install
%find_lang %_name

%files -f %_name.lang
%_bindir/%name-client
%_libexecdir/%name/
%{?_enable_applet:%exclude %_libexecdir/%name/%name-applet}
%_desktopdir/%xdg_name.Ui.desktop
%_desktopdir/%xdg_name.Preferences.desktop
%_datadir/metainfo/%xdg_name.Ui.appdata.xml
%_prefix/lib/systemd/user/%xdg_name.Ui.service
%_datadir/dbus-1/services/*.service
%_userunitdir/%xdg_name.service
%_userunitdir/%xdg_name.Preferences.service
%_datadir/glib-2.0/schemas/*.xml
%_datadir/gnome-control-center/keybindings/*.xml
%_man1dir/%name-client.1.*

%_datadir/bash-completion/completions/gpaste-client
%_datadir/zsh/site-functions/_gpaste-client
%doc AUTHORS NEWS README.md THANKS TODO COPYING

%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%_libdir/lib%name-gtk-3.so.*
%_libdir/lib%name-gtk4.so.*

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/lib%name-%api_ver.so
%_libdir/lib%name-gtk-3.so
%_libdir/lib%name-gtk4.so
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-gtk-3.pc
%_pkgconfigdir/%name-gtk-4.pc
%_vapidir/%name-%api_ver.deps
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-gtk-3.deps
%_vapidir/%name-gtk-3.vapi
%_vapidir/%name-gtk-4.deps
%_vapidir/%name-gtk-4.vapi

%files -n lib%name-gir
%_typelibdir/%_name-%api_ver.typelib
%_typelibdir/%{_name}Gtk-3.typelib
%_typelibdir/%{_name}Gtk-4.typelib

%files -n lib%name-gir-devel
%_girdir/%_name-%api_ver.gir
%_girdir/%{_name}Gtk-3.gir
%_girdir/%{_name}Gtk-4.gir

%if_enabled applet
%files applet
%_libexecdir/%name/%name-applet
%_datadir/metainfo/%xdg_name.Applet.appdata.xml
%_datadir/applications/%xdg_name.Applet.desktop
%_prefix/lib/systemd/user/%xdg_name.Applet.service
%_sysconfdir/xdg/autostart/%xdg_name.Applet.desktop
%endif

%files -n gnome-shell-extension-%name
%_datadir/gnome-shell/extensions/GPaste@gnome-shell-extensions.gnome.org/
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini

%changelog
