# sources are not ported to qt5
%def_with qt4
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Program to solve mathematical puzzles

Name:           kitsune
Version:        3.0
Release:        alt1_8
Summary:        %{sum}
Group:          Games/Puzzles
License:        GPLv2+
URL:            https://kitsune.tuxfamily.org/wiki/doku.php
Source0:        https://download.tuxfamily.org/kitsune/%{name}%{version}/%{name}%{version}.tar.gz
Source1:        kitsune-de.ts
Patch0:         kitsune-3.0-mga-manage-translations.patch

BuildRequires:  icoutils icoutils-extra
%if_with qt4
BuildRequires:  libqt4-devel
%else
BuildRequires:  qt5-base-devel qt5-declarative-devel qt5-tools
%endif
Source44: import.info

%description
Kitsune is a software aiming at solving digit problems of a famous
television game show called "Countdown" in England and "Des chiffres
et des lettres" in France.

It enables you to solve a problem of your choice, or to train yourself
with random problems. Facing a problem, Kitsune will find all the different
solutions: if the problem is solvable, this software will put up all the
ways to reach the target. If the problem is not solvable, it will put up
the best approximations. 

%prep
%setup -q -n %{name}%{version}
%patch0 -p1


# German translation seems to be missing from the source tarball
cp %{_sourcedir}/%{name}-de.ts txt/de/%{name}.ts

%build
%if_with qt4
lrelease-qt4 kitsune.pro
%qmake_qt4
%else
lrelease-qt5 kitsune.pro
%qmake_qt5
%endif
%make_build

%install
# Install binary
mkdir -p %{buildroot}%{_gamesbindir}
install -m 755 bin/kitsune %{buildroot}%{_gamesbindir}

# Extract and install icon
for size in 16 32 48; do
  install -d %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/
  icotool -x --width=${size} appliwin.ico -o %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

# Remove translation source files from doc, and all pt content
find -name "*.ts" -delete
rm txt/pt -rf

# Mageia menu entry
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Kitsune
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF

%files
%doc Changelog.txt txt/*
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
