Name: lapack
Version: 3.8.0
Release: alt8
Epoch: 1

%define sover 4
%define soname lib%name.so.%sover
%def_without bootstrap

Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
License: BSD
Group: Development/Other
Url: http://www.netlib.org/

Source: %name-%version.tar
Source1: manpages.tar

Patch100: CVE-2021-4048.patch

BuildRequires: cmake gcc-fortran libxblas-devel
%{!?_with_bootstrap:BuildRequires: libsuperlu-devel}
BuildRequires: libopenblas-devel

%package -n lib%name
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: System/Libraries
Conflicts: lib%name-goto < %epoch:%version-%release
Obsoletes: lib%name-goto < %epoch:%version-%release
Obsoletes: liblapack3

%package -n lib%name-devel
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Other
Requires: libopenblas-devel
Requires: lib%name = %epoch:%version-%release
Conflicts: lib%name-goto-devel
Obsoletes: lib%name-goto-devel

%package -n blas-man
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Documentation
BuildArch: noarch
Conflicts: blas-man < %epoch:%version-%release
Obsoletes: blas-goto-man

%package -n lapack-man
Summary: BLAS and LAPACK Fortran libraries for numerical linear algebra (with GotoBLAS2)
Group: Development/Documentation
Requires: blas-man = %epoch:%version-%release
BuildArch: noarch
Conflicts: lapack-man < %epoch:%version-%release
Obsoletes: lapack-goto-man

%description
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lib%name
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lib%name-devel
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n blas-man
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%description -n lapack-man
LAPACK (Linear Algebra PACKage) is a standard library for numerical
linear algebra. LAPACK provides routines for solving systems of
simultaneous linear equations, least-squares solutions of linear
systems of equations, eigenvalue problems, and singular value
problems. Associated matrix factorizations (LU, Cholesky, QR, SVD,
Schur, and generalized Schur) and related computations (i.e.,
reordering of Schur factorizations and estimating condition numbers)
are also included. LAPACK can handle dense and banded matrices, but
not general sparse matrices. Similar functionality is provided for
real and complex matrices in both single and double precision.

%prep
%setup -a1
%patch100 -p1

export LC_COLLATE=C
ls manpages/blas/man/manl >blas.manpages
ls manpages/man/manl >lapack.manpages
comm -12 blas.manpages lapack.manpages >dup.manpages
(cd manpages/man/manl; xargs -r rm -v -- ) <dup.manpages || exit 1
rm blas.manpages lapack.manpages dup.manpages
rm -fR BLAS

%build
%add_optflags %optflags_shared
%cmake \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DBLAS_goto2_LIBRARY:FILEPATH=%_libdir/libopenblas.so \
	-DUSE_XBLAS:BOOL=ON \
	-DBUILD_DEPRECATED:BOOL=ON \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DBUILD_STATIC_LIBS:BOOL=OFF \
	-DSOVER:STRING=%sover

%cmake_build

%install
%cmakeinstall_std

for f in manpages/blas/man/manl/*.l; do
	m=$(basename "$f" .l).3f
	install -pD -m644 $f %buildroot%_man3dir/"$m"
	echo %_man3dir/"$m*"
done >blas-man.files

for f in manpages/man/manl/*.l; do
	m=$(basename "$f" .l).3f
	# some lapack pages miss .TH header
	if grep -qs -i '^[.]TH[[:space:]]' "$f"; then
		install -pD -m644 $f %buildroot%_man3dir/"$m"
	else
		echo ".TH $(echo ${m%%.3f} |sed -e 's/.*/\U&/') 3" >%buildroot%_man3dir/"$m"
		cat "$f" >>%buildroot%_man3dir/"$m"
	fi
	echo %_man3dir/"$m*"
done >lapack-man.files

%files -n lib%name
%define _customdocdir %_docdir/lapack-3.1
%doc LICENSE README.md
%_libdir/%soname

%files -n lib%name-devel
%_libdir/liblapack.so
%dir %_libdir/cmake
%_libdir/cmake/*
%_pkgconfigdir/*

%files -n blas-man -f blas-man.files
%files -n lapack-man -f lapack-man.files

%changelog
