%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%define soname 8

Name: libffi
Version: 3.5.1
Release: alt1
Epoch: 1

Summary: Foreign Function Interface library
License: MIT
Group: System/Libraries
URL: https://sourceware.org/libffi/
VCS: https://github.com/libffi/libffi
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu, gcc-c++, /proc, /dev/pts}}

BuildRequires: makeinfo

%description
The libffi library provides a portable, high level programming
interface to various calling conventions.  This allows a programmer
to call any function specified by a call interface description
at run time.

%package -n libffi%soname
Summary: Header files and library for Foreign Function Interface development
Group: System/Libraries
Provides: libffi = %epoch:%version-%release

%description -n libffi%soname
The libffi library provides a portable, high level programming
interface to various calling conventions.  This allows a programmer
to call any function specified by a call interface description
at run time.

This package contains Foreign Function Interface shared library
which is needed to run Foreign Function Interface dynamically
linked programs.

%package devel
Summary: Header files and library for Foreign Function Interface development
Group: Development/Other
Requires: libffi%soname = %epoch:%version-%release

%description devel
The libffi library provides a portable, high level programming
interface to various calling conventions.  This allows a programmer
to call any function specified by a call interface description
at run time.

This package includes the header files and library needed for
Foreign Function Interface development.

%package devel-static
Summary: Static library for Foreign Function Interface development
Group: Development/Other
Requires: libffi-devel = %epoch:%version-%release

%description devel-static
The libffi library provides a portable, high level programming
interface to various calling conventions.  This allows a programmer
to call any function specified by a call interface description
at run time.

This package includes the static library needed for
Foreign Function Interface development.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure --disable-exec-static-tramp
%make_build

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
make -k check

%install
%makeinstall_std

%files -n %name%soname
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files devel
%doc README.md
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_man3dir/*
%_infodir/*

%files devel-static
%_libdir/*.a

%changelog
