Name: libntlm
Version: 1.5
Release: alt2

Summary: NTLMv1 authentication library
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://nongnu.org/libntlm/
# https://nongnu.org/libntlm/releases/%name-%version.tar.gz
Source: %name-%version.tar

Patch1: upstream-fix-buffer-overflow-CVE-2019-17455.patch

%description
%name is a library for authenticating with Microsoft NTLMv1
challenge-response, derived from Samba sources.

Warning: NTLMv1 is not a secure authentication protocol -- it uses MD4
and single-DES.  MD4 has been broken, and single-DES have a too small
key size to be considered secure against brute-force attacks.  One
should consider using libntlm for interoperability purposes only,
not to achieve any kind of security.

%package devel
Summary: Files for development of %name-based applications
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains files for development of %name-based applications.

%prep
%setup
%patch1 -p1

%build
%configure --disable-static
%make_build

%install
%makeinstall_std

%check
%make_build -k check

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README THANKS

%files devel
%_libdir/*.so
%_includedir/*.h
%_pkgconfigdir/*.pc

%changelog
