# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libsimdjson
Version: 3.9.1
Release: alt1.1
Summary: Parsing gigabytes of JSON per second
License: Apache-2.0
Group: System/Libraries
Url: https://simdjson.org/
Vcs: https://github.com/simdjson/simdjson

Source: %name-%version.tar
Patch: simdjson-loongarch-link-flags.patch
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++

%description
JSON is everywhere on the Internet. Servers spend a *lot* of time parsing it.
We need a fresh approach. The simdjson library uses commonly available SIMD
instructions and microparallel algorithms to parse JSON 4x faster than
RapidJSON and 25x faster than JSON for Modern C++.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
%summary

%prep
%setup
%autopatch -p1

%build
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DBUILD_SHARED_LIBS=ON
%cmake_build

%install
%cmake_install

%check
grep -P '^#define\s+SIMDJSON_VERSION\s+"\Q%version\E"' %buildroot%_includedir/simdjson.h
export LD_LIBRARY_PATH=$PWD/%_cmake__builddir
c++ -Iinclude examples/quickstart/quickstart.cpp -L%_cmake__builddir -lsimdjson
cd jsonexamples
../a.out

%files
%doc LICENSE
%_libdir/libsimdjson.so.*

%files devel
%doc AUTHORS CONTRIBUTORS *.md
%_includedir/simdjson.h
%_libdir/libsimdjson.so
%_libdir/cmake/simdjson
%_pkgconfigdir/simdjson.pc

%changelog
