# TODO: build json11 separately

# see LIBTGVOIP_VERSION in VoIPController.h for a version

%def_with json11

Name: libtgvoip
Version: 2.4.4
Release: alt6.f321e7c8

Summary: VoIP library for Telegram clients

Group: Networking/Instant messaging
License: Public Domain and BSD

Url: https://github.com/telegramdesktop/libtgvoip
Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source-git: https://github.com/grishka/libtgvoip.git
# Source-git: https://github.com/telegramdesktop/libtgvoip.git
Source: %name-%version.tar

Patch1: libtgvoip-system-json11.patch

# TODO:
# from webrtc_dsp/modules/audio_processing/aec/aec_core_sse2.cc:17:
# /usr/lib/gcc/i586-alt-linux/9/include/xmmintrin.h:932:1: error: inlining failed in call to always_inline '__m128 _mm_loadu_ps(const float*)': target specific option mismatch
#  932 | _mm_loadu_ps (float const *__P)
%ifarch %ix86
%add_optflags -msse2
%endif

#add_optflags -DTGVOIP_USE_DESKTOP_DSP_BUNDLED

BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: libalsa-devel libpulseaudio-devel
# >= 1.3
BuildRequires: libopus-devel
#BuildRequires: libowt-tg-devel
%if_with json11
BuildRequires: libjson11-devel
%endif

%description
VoIP library for Telegram clients.
Dinamically loads libalsa or libpulse.


%package devel
Group: Development/Other
Summary: Development files for %name
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.


%prep
%setup

%if_with json11
%patch1 -p1
# remove bundled json11
rm -vf json11.*
%endif

%__subst "s|-std=gnu++0x|-std=gnu++17|" Makefile.am

%build
%autoreconf
%configure --disable-static --disable-dsp
%make_build

%install
%makeinstall_std

%files
%_libdir/libtgvoip.so.*

%files devel
%doc UNLICENSE
%_libdir/libtgvoip.so
%dir %_includedir/tgvoip/
%_includedir/tgvoip/*.h
%if_without json11
%_includedir/tgvoip/json11.hpp
%endif
%_includedir/tgvoip/audio/
%_includedir/tgvoip/video/
%_includedir/tgvoip/os/
%_pkgconfigdir/tgvoip.pc

%changelog
