# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
# -*- rpm-spec -*-

%global meson_version 0.49.0
%global glib2_version 2.44.0
%global libvirt_version 3.1.0
%global libvirt_glib_version 0.0.7
%global system_user libvirtdbus

Name:    libvirt-dbus
Version: 1.4.1
Release: alt2
Summary: libvirt D-Bus API binding
License: LGPL-2.1-or-later
Group:   System/Libraries
Url:     https://libvirt.org/
Source0: https://libvirt.org/sources/dbus/%name-%version.tar.xz
Patch:   alt-service-option.patch

BuildRequires: gcc
BuildRequires: meson >= %meson_version
BuildRequires: glib2-devel libgio libgio-devel
BuildRequires: libvirt-devel >= %libvirt_version
BuildRequires: libvirt-glib-devel libvirt-glib-gir-devel
BuildRequires: python3-module-docutils python3-module-flake8
BuildRequires: rpm-macros-systemd
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit

Requires: dbus
Requires: libgio >= %glib2_version
Requires: libvirt-libs >= %libvirt_version
Requires: libvirt-glib-gir >= %libvirt_glib_version
Requires: polkit

Requires(pre): shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils

%description
This package provides D-Bus API for libvirt

%prep
%setup
%patch -p1

%build
%meson \
    -Dinit_script=systemd
%meson_build

%install
%meson_install

%pre
getent group %system_user >/dev/null || groupadd -r %system_user
getent passwd %system_user >/dev/null || \
    useradd -r -g %system_user -d / -s /sbin/nologin \
    -c "Libvirt D-Bus bridge" %system_user
exit 0

%post
%post_service %name
%systemd_user_post %name.service

%preun
%preun_service %name
%systemd_user_preun %name.service

%postun
%systemd_user_postun_with_restart %name.service

%files
%doc NEWS.rst
%doc COPYING
%_sbindir/libvirt-dbus
%_unitdir/libvirt-dbus.service
%_userunitdir/libvirt-dbus.service
%_datadir/dbus-1/services/org.libvirt.service
%_datadir/dbus-1/system-services/org.libvirt.service
%_datadir/dbus-1/system.d/org.libvirt.conf
%_datadir/dbus-1/interfaces/org.libvirt.*.xml
%_datadir/polkit-1/rules.d/libvirt-dbus.rules
%_mandir/man8/libvirt-dbus.8*

%changelog
