Name: netatalk
Version: 3.2.8
Release: alt1

Summary: Open Source Apple Filing Protocol (AFP) File Server

License: GPLv2+
Group: Networking/Other
Url: http://netatalk.sourceforge.net

Source0: http://download.sourceforge.net/netatalk/netatalk-%version.tar.xz
Source1: netatalk.pam-system-auth
Patch0: netatalk-3.0.1-basedir.patch
Patch1: netatalk-3.1.12-alt-mysql8-transition.patch
Patch2: netatalk-3.1.12-afpstats-python3-compat.patch
Patch3: netatalk-systemd-execstartpre.patch


BuildRequires(pre): rpm-build-python3
BuildRequires: cracklib-devel flex libacl-devel libattr-devel libavahi-devel
BuildRequires: libdb4-devel libdbus-glib-devel libevent-devel libgcrypt-devel
BuildRequires: libkrb5-devel libldap-devel libmysqlclient-devel libpam-devel
BuildRequires: libssl-devel libtdb-devel perl-bignum perl-IO-Socket-INET6 rpm-build-perl perl-Net-DBus
Requires: cracklib-words cracklib

%description
Netatalk is a freely-available Open Source AFP file server. A *NIX/*BSD
system running Netatalk is capable of serving many Macintosh clients
simultaneously as an AppleShare file server (AFP).

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/C

%description devel
This package contains libraries and header files for
developing applications that use %name.

%prep
%setup

# use system libevent instead
rm -frv libevent/

#patch0 -p1
%patch1 -p0
#patch2 -p1
#patch3 -p0

# Avoid re-running the autotools
#touch -r aclocal.m4 configure configure.ac macros/gssapi-check.m4

# fix permissions
find include \( -name '*.h' -a -executable \) -exec chmod -x {} \;

# py2 -> py3
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ \( -name '*.py' -o -name 'afpstats' \))

# Don't call systemctl daemon-reload during the build
sed -i 's\-systemctl daemon-reload\\g' distrib/initscripts/Makefile.am


%build
%autoreconf
%add_optflags -fcommon
%configure \
        --localstatedir=%_localstatedir             \
        --with-acl                                  \
        --with-cracklib                             \
        --with-docbook                              \
        --with-kerberos                             \
        --with-libgcrypt                            \
        --with-pam                                  \
        --with-pkgconfdir=%_sysconfdir/netatalk/    \
        --with-shadow                               \
        --with-tbd=no                               \
        --with-uams-path=%_libdir/netatalk          \
        --enable-pgp-uam                            \
        --enable-shared                             \
        --enable-krbV-uam                           \
        --enable-overwrite                          \
        --with-init-style=redhat-systemd            \
        --with-spotlight                            \
        --with-dbus-daemon=/usr/bin/dbus-daemon     \
        --without-libevent                          \
        --with-libevent-header=%_includedir         \
        --with-libevent-lib=%_libdir                \
        --without-tdb                               \
        --with-bdb                                  \
        --disable-silent-rules                      \
        --disable-static

%make_build

# Build the local docs.
make -C doc/manual html-local

%install
%makeinstall_std
# Ghost lock dir.
mkdir -p %buildroot/var/lock/netatalk

# Use specific pam conf.
mkdir -p %buildroot%_sysconfdir/pam.d
install -pm644 %SOURCE1 %buildroot%_sysconfdir/pam.d/netatalk

mkdir -p %buildroot%_sysconfdir/dbus-1/system.d/
cp %buildroot/usr/etc/dbus-1/system.d/netatalk-dbus.conf %buildroot%_sysconfdir/dbus-1/system.d/
find %buildroot -name '*.la' -delete -print

touch %buildroot%_sysconfdir/netatalk/afppasswd

%check
sh test/afpd/test.sh

%files
%doc CONTRIBUTORS NEWS COPYING COPYRIGHT
%config(noreplace) %_sysconfdir/dbus-1/system.d/netatalk-dbus.conf
%dir %_sysconfdir/netatalk
%config(noreplace) %_sysconfdir/netatalk/afp.conf
%config(noreplace) %_sysconfdir/netatalk/dbus-session.conf
%config(noreplace) %_sysconfdir/netatalk/extmap.conf
%config(noreplace) %_sysconfdir/pam.d/netatalk
%config(noreplace) %_sysconfdir/netatalk/afppasswd
/usr/etc/dbus-1/system.d/netatalk-dbus.conf
/usr/etc/pam.d/netatalk
%_bindir/*
%exclude %_bindir/netatalk-config
%_libdir/netatalk/
%_libdir/libatalk.so.*
%_mandir/man*/*
%exclude %_mandir/man*/netatalk-config*
%_sbindir/*
%ghost %dir /var/lock/netatalk
/usr/lib/systemd/system/netatalk.service
%exclude %_localstatedir/netatalk/CNID/README
%exclude %_localstatedir/netatalk/README
%dir /var/lib/netatalk

%files devel
%_bindir/netatalk-config
%_datadir/aclocal/netatalk.m4
%_includedir/atalk/
%_libdir/libatalk.so
%_mandir/man*/netatalk-config.1*

%changelog
