Name: nmap
Version: 7.94
Release: alt3
Epoch: 20020501

Summary: Network exploration tool and security scanner
License: ALT-NPSL-0.95
Group: Monitoring
Url: http://nmap.org/

%define srcname nmap-%version-%release
# http://git.altlinux.org/gears/n/nmap.git
Source: %srcname.tar
Source1: zenmap.pamd
Source2: zenmap.security

%def_with liblua
%def_with ncat
%def_with ndiff
%def_with nping
%def_with zenmap

Requires: chrooted-resolv
BuildRequires: gcc-c++, libcap-devel
BuildRequires: libpcap-devel >= 2:0.8, libpcre-devel, libssl-devel, libssh2-devel, zlib-devel
# nmap/configure.ac:836:    # We need Lua 5.4 exactly
%{?_with_liblua:BuildRequires: liblua5.4-devel}
%{?_with_ndiff:BuildRequires: python3-devel python3-module-setuptools}
%{?_with_zenmap:BuildRequires: libpam-devel python3-devel}

# Nmap Lua scripts are self-contained;
# they do not rely on any external Lua modules.
AutoReq: nolua

%description
Nmap is an utility for network exploration or security auditing.
It supports ping scanning (determine which hosts are up), many port
scanning techniques, version detection (determine service protocols and
application versions listening behind ports), and TCP/IP fingerprinting
(remote host OS or device identification).  Nmap also offers flexible
target and port specification, decoy/stealth scanning, Sun RPC scanning,
and more.

%package -n zenmap
Summary: The GTK+ frontend for Nmap
Group: Monitoring
BuildArch: noarch
%_python3_set_noarch
%add_python3_req_skip gobject
Requires: %name = %EVR

%description -n zenmap
This package includes zenmap, a GTK+ frontend for Nmap.

%prep
%setup -n %srcname
rm -r liblua libpcap libpcre libssh2 libz
gzip -9 CHANGELOG

%build
for d in . nping; do
	pushd $d
	aclocal
	autoheader
	autoconf
	popd
done

%add_optflags -D_FILE_OFFSET_BITS=64

export ac_cv_header_libiberty_h=no
export ac_cv_dnet_linux_procfs=yes
%configure \
	%{subst_with liblua} \
	%{subst_with ncat} \
	%{subst_with ndiff} \
	%{subst_with nping} \
	%{subst_with zenmap} \
	--with-user=nmapuser \
	--with-chroot-empty=/var/empty \
	--with-chroot-resolv=/var/resolv \
	#
%make_build

%install
%makeinstall_std STRIP=:

rm %buildroot%_bindir/uninstall_ndiff
rm %buildroot%_mandir/*/man1/nmap.*

%if_with zenmap
ln -s $(relative %_libexecdir/consolehelper/helper %_bindir/) \
	%buildroot%_bindir/zenmap-root
install -pD -m640 %_sourcedir/zenmap.pamd \
	%buildroot%_sysconfdir/pam.d/zenmap-root
install -pD -m640 %_sourcedir/zenmap.security \
	%buildroot%_sysconfdir/security/console.apps/zenmap-root
mkdir -p %buildroot%_liconsdir
ln -s ../../../../zenmap/pixmaps/zenmap.png %buildroot%_liconsdir/
%find_lang zenmap
rm %buildroot%_bindir/{nmapfe,uninstall_zenmap,xnmap}
rm %buildroot%_datadir/zenmap/su-to-zenmap.sh
%endif

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%pre
/usr/sbin/groupadd -r -f nmapuser
/usr/sbin/useradd -r -g nmapuser -d /dev/null -s /dev/null -n nmapuser >/dev/null 2>&1 ||:

%files
%_bindir/nmap
%_datadir/nmap
%_man1dir/nmap.*
%if_with ncat
%_bindir/ncat
%_man1dir/ncat.*
%endif
%if_with ndiff
%_bindir/ndiff
%_man1dir/ndiff.*
%python3_sitelibdir/ndiff.py
%python3_sitelibdir/__pycache__/ndiff*
%endif
%if_with nping
%_bindir/nping
%_man1dir/nping.*
%endif
%doc LICENSE CHANGELOG.gz docs/{README,nmap*.txt}

%if_with zenmap
%files -n zenmap -f zenmap.lang
%config(noreplace) %_sysconfdir/pam.d/zenmap-root
%config(noreplace) %_sysconfdir/security/console.apps/zenmap-root
%_bindir/zenmap*
%_datadir/zenmap
%_man1dir/zenmap.*
%_liconsdir/*
%_desktopdir/zenmap*.desktop
%python3_sitelibdir/radialnet
%python3_sitelibdir/zenmapCore
%python3_sitelibdir/zenmapGUI
%python3_sitelibdir/zenmap-%{version}-*.egg-info
%endif

%changelog
