%define _name findlib
Name: ocaml-%_name
Version: 1.9.6
Release: alt2
Summary: A module packaging tool for OCaml
License: MIT
Group: Development/ML
Url: https://projects.camlcity.org/projects/findlib.html
VCS: https://github.com/ocaml/ocamlfind
Source: %_name-%version.tar
BuildRequires: rpm-build-ocaml >= 1.6 ocaml-labltk-devel >= 8.06.2 libtinfo-devel ocaml-ocamldoc
BuildRequires: ocaml-ocamlbuild libX11-devel tcl-devel tk-devel libncurses-devel openjade

%description
The "findlib" library provides a scheme to manage reusable software
components (packages), and includes tools that support this
scheme. Packages are collections of OCaml modules for which
metainformation can be stored. The packages are kept in the filesystem
hierarchy, but with strict directory structure. The library contains
functions to look the directory up that stores a package, to query
metainformation about a package, and to retrieve dependency
information about multiple packages. There is also a tool that allows
the user to enter queries on the command-line. In order to simplify
compilation and linkage, there are new frontends of the various OCaml
compilers that can directly deal with packages.


%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %_name-%version

sed -i -e 's,@LIBDIR@,%_libdir,g' src/findlib-toolbox/make_wizard.ml
sed -i -e '/path/s,@SITELIB@,\0:%_libdir/ocaml,' findlib.conf.in

%build
(cd tools/extract_args && make)
tools/extract_args/extract_args -o src/findlib/ocaml_args.ml ocamlc ocamlcp ocamlmktop ocamlopt ocamldep ocamldoc ||:
cat src/findlib/ocaml_args.ml
./configure \
    -no-custom \
    -mandir %_mandir \
    -config %_libdir/ocaml/etc/findlib.conf \
    -sitelib `ocamlc -where` \
    #
make all OCAMLC_FLAGS=-bin-annot
%ifarch %ocaml_native_arch
make opt OCAMLC_FLAGS=-bin-annot
%endif

%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man{1,5}
make install \
     prefix=$RPM_BUILD_ROOT \
     OCAMLFIND_BIN=%{_bindir} \
     OCAMLFIND_MAN=%{_mandir}
%__install -m644 src/findlib/*.cmt* %buildroot%_ocamldir/findlib/
%ocaml_find_files

%files -f ocaml-files.runtime
%doc LICENSE
%_bindir/ocamlfind
%_libdir/ocaml/topfind
%_libdir/ocaml/etc/*
%_man1dir/ocamlfind.1*
%_man5dir/*

%files devel -f ocaml-files.devel
%doc doc/README doc/guide-html
%_libdir/ocaml/findlib/Makefile.config
%_libdir/ocaml/findlib/Makefile.packages

%changelog
