%define soname 12

Name: primesieve
Version: 12.3
Release: alt1
Summary: A prime number generator
License: BSD-2-Clause
Group: Sciences/Mathematics
Url: https://github.com/kimwalisch/primesieve

Source: https://github.com/kimwalisch/primesieve/archive/v%version.tar.gz#/%name-%version.tar.gz

BuildPreReq: rpm-build-ninja ctest
BuildRequires: gcc-c++ cmake >= 3.7 doxygen texlive asciidoc-a2x graphviz

%description
primesieve is a command-line program that generates primes using the
sieve of Eratosthenes algorithm. It can generate primes and prime
k-tuplets (twin primes, prime triplets, ...) up to 2^64 and find the
nth prime.

%package -n lib%name%soname
Summary: C/C++ library for generating prime numbers
Group: System/Libraries

%description -n lib%name%soname
This package contains the shared runtime library for primesieve.

%package -n lib%name-devel
Summary: Development files for the primesieve library
Group: Development/Other

%description -n lib%name-devel
This package contains the C/C++ header files and the configuration
files for developing applications that use the primesieve library.
It also contains the API documentation of the library.

%prep
%setup

%build
%cmake \
    -GNinja \
    -DBUILD_STATIC_LIBS=OFF \
    -DBUILD_DOC=ON \
    -DBUILD_MANPAGE=ON \
    -DBUILD_TESTS=ON \
    -DCMAKE_SKIP_RPATH:BOOL=OFF
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install

%check
cd %_cmake__builddir
ctest

%files
%doc README.md ChangeLog
%_bindir/primesieve
%_man1dir/primesieve.1*

%files -n lib%name%soname
%doc COPYING
%_libdir/libprimesieve.so.%{soname}*

%files -n lib%name-devel
%doc examples
%_libdir/libprimesieve.so
%_includedir/primesieve.h
%_includedir/primesieve.hpp
%dir %_includedir/primesieve
%_includedir/primesieve/StorePrimes.hpp
%_includedir/primesieve/iterator.h
%_includedir/primesieve/iterator.hpp
%_includedir/primesieve/primesieve_error.hpp
%dir %_libdir/cmake/primesieve
%_libdir/cmake/primesieve/*.cmake
%_pkgconfigdir/primesieve.pc

%changelog
