# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: psmisc
Version: 23.6
Release: alt3

Summary: Miscellaneous utilities that use proc filesystem
License: GPL-2.0-only
Group: System/Base
Url: https://gitlab.com/psmisc/psmisc
Vcs: https://gitlab.com/psmisc/psmisc.git
Source: %name-%version.tar

%def_enable selinux
BuildRequires: libncurses-devel %{?_enable_selinux:libselinux-devel}
BuildRequires: libseccomp-devel
BuildRequires: libcap-devel
%{?!_without_check:%{?!_disable_check:BuildRequires: banner dejagnu rpm-build-vm >= 1.9 nc strace /proc}}
%ifarch %e2k
# required for asan
%{?!_without_check:%{?!_disable_check:BuildRequires: libcompiler_rt}}
%endif

%description
A package of small utilities that use proc filesystem.
  fuser   - Identifies processes using files or sockets
  killall - Kills processes by name, e.g. killall -HUP named
  prtstat - Prints statistics of a process
  pslog   - Prints log path(s) of a process
  pstree  - Shows currently running processes as a tree
  peekfd  - Shows the data travelling over a file descriptor

%prep
%setup

%define _configure_script ../configure
%build
./autogen.sh
mkdir build
cd build
%configure %{subst_enable selinux} --disable-harden-flags --enable-sandbox
%make_build

%install
%makeinstall_std -C build
mkdir -p %buildroot/sbin
mv %buildroot%_bindir/fuser %buildroot/sbin/
ln -s ../../sbin/fuser %buildroot%_bindir/

pushd %buildroot%_bindir/
ln -sf pstree pstree.x11
popd

%find_lang %name

%check
pushd build
PATH=%buildroot/sbin:%buildroot%_bindir:$PATH
%ifarch x86_64
 strace -o killall.log killall -s0 -u $USER
 grep ^seccomp.*SECCOMP_SET_MODE_FILTER killall.log
 grep ^prlimit.*RLIMIT_NPROC killall.log
 grep ^capset.*CAP_SYS_PTRACE killall.log
%endif

my_tests() {
  type killall pstree prtstat fuser pslog peekfd || :
  killall --list
  sleep 1m & sleep 1; killall sleep
  sleep 1m & sleep 1; killall -e sleep
  sleep 1m & sleep 1; killall -I SLEEP
  sleep 1m & sleep 1; killall -r sl.ep
  sleep 1m & sleep 1; killall -v sleep
  sleep 1m & sleep 1; killall -w sleep
  ! killall -s0 killall
  killall -s0 -u $USER
  yes | killall -s0 -u $USER -i > /dev/null
  pstree
  pstree -a >/dev/null
  pstree -A >/dev/null
  pstree -c >/dev/null
  pstree -g >/dev/null
  pstree -l >/dev/null
  pstree -n >/dev/null
  pstree -p >/dev/null
  pstree -S >/dev/null
  pstree -s >/dev/null
  pstree -t >/dev/null
  pstree -T >/dev/null
  pstree -u >/dev/null
  pstree -U >/dev/null
  prtstat $$
  prtstat -r $$
  fuser --list-signals
  fuser -v /proc  >/dev/null
  fuser -mv /proc >/dev/null
  fuser -m . -n file >/dev/null
  fuser -m . -n udp  >/dev/null
  fuser -m . -n tcp  >/dev/null
  fuser -m . -u  >/dev/null
  fuser -m . -4  >/dev/null
  fuser -m . -6  >/dev/null
  nc -l socks & sleep 1
  fuser -v socks/tcp
  kill %%1
  pslog $$
}
export -f my_tests

banner TESTS
my_tests
make check

banner VM
vm-run "set -xe
  type killall
  /sbin/capsh --user=nobody -- -c 'sleep 1m' & sleep 1; killall sleep
  /sbin/capsh --user=nobody -- -c 'sleep 1m' & sleep 1; killall -u nobody
  # conflicts with kernel.yama.ptrace_scope=1
  if type peekfd 2>/dev/null; then
    timeout 1 peekfd \$\$ || test \$? = 124
  fi
  my_tests"
popd

%ifnarch riscv64
banner ASAN
PATH=src:$PATH
mkdir asan
cd asan
# detect_leaks=0 or configure will fail to detect malloc due to leak in test
export ASAN_OPTIONS=detect_leaks=0
CFLAGS=-fsanitize=address \
     ../configure %{subst_enable selinux} --disable-harden-flags -q --disable-sandbox
%make_build -s
my_tests
make check
%endif

%files -f %name.lang
/sbin/*
%_bindir/*
%_man1dir/*.1*
%doc AUTHORS ChangeLog COPYING README.md

%changelog
